/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.dialog;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.InputDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.lang.UUID;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.behavior.event.CollectionCreatedEvent;
import com.amazon.kindle.control.util.CatalogUtils;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.keyboard.KeyboardUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class AddCollectionDialog
extends InputDialog {
    private boolean mShowError;
    private Booklet mBooklet;
    private String mOldCollectionName;
    private JButton mSaveButton;
    private UUID mCollectionId;
    private CatalogItem mItemToAdd;
    private KeyAdapter mKeyListener;

    public AddCollectionDialog(Booklet a) {
        a2(a, null, false);
        AddCollectionDialog a2;
    }

    public AddCollectionDialog(Booklet a, CatalogItem a2) {
        a3(a);
        AddCollectionDialog a3;
        if (a2 == null) {
            throw new NullPointerException("null:catalog item");
        }
        a3.mItemToAdd = a2;
    }

    public AddCollectionDialog(Booklet a, String a2, UUID a3) {
        a4(a, a2, false);
        AddCollectionDialog a4;
        if (a3 == null) {
            throw new NullPointerException("null:collection id");
        }
        a4.mCollectionId = a3;
    }

    public void postDialog() {
        AddCollectionDialog a;
        a.postDialog(true);
    }

    public String getInputText() {
        AddCollectionDialog a;
        return super.getInputText().trim();
    }

    protected AddCollectionDialog(Booklet a, String a2, boolean a3) {
        AddCollectionDialog a4;
        if (a == null) {
            throw new NullPointerException("null:Booklet");
        }
        a4.mBooklet = a;
        a4.setAppId(a4.mBooklet.getBookletContext().getName());
        int a5 = (Integer)ResourceBundle.getBundle("com.amazon.kindle.control.resources.DialogResources").getObject("addcollection.maxlength");
        a4.mOldCollectionName = a2 != null && a2.length() > a5 ? a2.substring(0, a5) : a2;
        a4.mShowError = a3;
        a4.initGUI();
    }

    protected void setCollectionId(UUID a) {
        if (a == null) {
            throw new NullPointerException("null:collection id");
        }
        a.mCollectionId = a;
    }

    protected void setItemToAdd(CatalogItem a) {
        a.mItemToAdd = a;
    }

    protected String getOldCollectionName() {
        AddCollectionDialog a;
        return a.mOldCollectionName;
    }

    protected String getCollectionName() {
        AddCollectionDialog a;
        return a.getInputText();
    }

    protected UUID getCollectionUUID() {
        AddCollectionDialog a;
        return a.mCollectionId;
    }

    protected CatalogItem getItemToAdd() {
        AddCollectionDialog a;
        return a.mItemToAdd;
    }

    private void initGUI() {
        AddCollectionDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.DialogResources");
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("addcollection.title"));
        if (a.mShowError) {
            a.setDescription(a2.getString("addcollection.error.label"));
        }
        a.mKeyListener = new KeyAdapter(){
            {
                1 a;
            }

            public void keyReleased(KeyEvent a) {
                if (a.getKeyCode() == 10) {
                    1 a2;
                    a.consume();
                    if (a2.AddCollectionDialog.this.mSaveButton.isEnabled()) {
                        a2.AddCollectionDialog.this.mSaveButton.getAction().actionPerformed(null);
                    }
                }
            }
        };
        int a3 = (Integer)a2.getObject("addcollection.minlength");
        int a4 = (Integer)a2.getObject("addcollection.maxlength");
        JTextArea a5 = a.getTextArea();
        KeyboardUtils.configure((JComponent)a5, (String)a2.getString("addcollection.keyboard"));
        a5.setDocument((Document)DialogUtils.getLimitedCharacterDocument(a4));
        a5.addKeyListener(a.mKeyListener);
        if (a.mOldCollectionName != null && a.mOldCollectionName.length() >= a3) {
            a.setInputText(a.mOldCollectionName);
        }
        CommandBar a6 = a.getCommandBar();
        a6.add((Component)DialogUtils.getCancelButton((KDialog)a));
        a.mSaveButton = DialogUtils.getOKButton(a.new SaveAction(a.mBooklet));
        a6.add((Component)a.mSaveButton);
        a.setButtonDisablePolicy(3);
    }

    private class SaveAction
    extends AbstractAction {
        private Booklet booklet;

        public SaveAction(Booklet a) {
            SaveAction a2;
            a2.booklet = a;
        }

        public void actionPerformed(final ActionEvent a) {
            SaveAction a2;
            ThreadPool.getInstance().runIt(new Runnable(){
                {
                    1 a2;
                }

                public void run() {
                    1 a6;
                    final String a2 = AddCollectionDialog.this.getInputText().trim();
                    if (a6.SaveAction.this.booklet == null) {
                        LogUtils.logBookletIsNull();
                        return;
                    }
                    if (a6.SaveAction.this.booklet.getBookletContext() == null) {
                        LogUtils.logBookletContextIsNull();
                        return;
                    }
                    if (a6.SaveAction.this.isRenamingCollection()) {
                        SwingUtilities.invokeLater(a6.SaveAction.this.getCloseRunnable(a6.a));
                        final boolean a3 = CatalogUtils.renameCollection(a6.SaveAction.this.booklet, AddCollectionDialog.this.getCollectionUUID(), a2);
                        SwingUtilities.invokeLater(new Runnable(){
                            {
                                SaveAction.1 a;
                            }

                            public void run() {
                                SaveAction.1 a;
                                if (!a.a3) {
                                    AddCollectionDialog a22 = new AddCollectionDialog(SaveAction.this.booklet, a.a2, true);
                                    a22.setCollectionId(AddCollectionDialog.this.getCollectionUUID());
                                    a22.postDialog();
                                }
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(a6.SaveAction.this.getCloseRunnable(a6.a));
                        final int a4 = CatalogUtils.getCollectionCount(a6.SaveAction.this.booklet);
                        final boolean a5 = CatalogUtils.addCollection(a6.SaveAction.this.booklet, a2, AddCollectionDialog.this.getItemToAdd());
                        SwingUtilities.invokeLater(new Runnable(){
                            {
                                2 a;
                            }

                            public void run() {
                                2 a;
                                if (a.a5) {
                                    CollectionCreatedEvent.getInstance().fireEvent(a.a4, a.a4 + 1);
                                } else {
                                    AddCollectionDialog a22 = new AddCollectionDialog(SaveAction.this.booklet, a.a2, true);
                                    a22.setItemToAdd(AddCollectionDialog.this.getItemToAdd());
                                    a22.postDialog();
                                }
                            }
                        });
                    }
                }
            }, "Add collection to home");
        }

        private Runnable getCloseRunnable(final ActionEvent a) {
            SaveAction a2;
            return new Runnable(){
                {
                    SaveAction.2 a2;
                }

                public void run() {
                    SaveAction.2 a2;
                    AddCollectionDialog.this.getCloseAction().actionPerformed(a2.a);
                }
            };
        }

        private boolean isRenamingCollection() {
            SaveAction a;
            return a.AddCollectionDialog.this.mCollectionId != null && a.AddCollectionDialog.this.getOldCollectionName().length() > 0 && CatalogUtils.doesCollectionExist(a.booklet, a.AddCollectionDialog.this.getOldCollectionName());
        }
    }
}

