/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control;

import com.amazon.agui.swing.KindleFrameFactory;
import com.amazon.agui.swing.MenuDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.GestureDispatchUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.AbstractBooklet;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.booklet.ChromeSearchBarButton;
import com.amazon.kindle.booklet.History;
import com.amazon.kindle.booklet.HistoryException;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.behavior.BookletBehavior;
import com.amazon.kindle.control.behavior.event.BookletStartEvent;
import com.amazon.kindle.control.behavior.event.PageTurnEvent;
import com.amazon.kindle.control.behavior.event.PostLoadViewEvent;
import com.amazon.kindle.control.behavior.event.PreLoadViewEvent;
import com.amazon.kindle.control.util.BehaviorUtils;
import com.amazon.kindle.control.util.BookletUtils;
import com.amazon.kindle.swing.actions.ActionManager;
import com.amazon.kindle.swing.events.BookletUIEvent;
import com.amazon.kindle.swing.events.BookletUIListener;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.RegistrationEvent;
import com.amazon.kindle.webservices.registration.RegistrationListener;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;

public abstract class DCBooklet
extends AbstractBooklet {
    protected static final String HISTORY_PARAM_VIEW = "historyView";
    protected static final String VIEW_REQUEST = "viewRequest";
    protected static final String SEARCH_ITEM_SELECTED_PARAM = "label";
    private static final Log LOG = Log.getInstance((String)"DisplayControllerBooklet");
    private static final LogMessage MENU_TAP_LOG = new LogMessage("ChromeMenuButton", new String[]{"context"});
    private static final LogMessage HISTORY_PUSH_ERR = new LogMessage("ErrorPushingHistory", new String[]{"context"});
    private static final LogMessage SWITCH_CONTROLLER_ERR = new LogMessage("ErrorSwitchingController", new String[]{"context", "activeView", "newView"});
    protected volatile DisplayController mActiveController;
    private ActionMap mGestureMap;
    private ActionManager mActionManager;
    private Map mViewCache;
    private boolean mActiveMenuVisible;
    private MenuButtonActionListener mMenuButtonListener;
    private RegistrationListener mRegistrationListener;
    private BookletUIListener mBookletUIListener;
    private URI mCurrentContent;

    public DCBooklet() {
        DCBooklet a;
    }

    public void create(BookletContext a) {
        DCBooklet a2;
        super.create(a);
        a2.mViewCache = new HashMap();
        a2.mActionManager = new ActionManager();
        a2.mMenuButtonListener = a2.new MenuButtonActionListener();
        a2.mRegistrationListener = a2.new DefaultRegistrationListener();
        a2.mBookletUIListener = a2.new DefaultBookletUIListener();
        a2.mBookletContext.addUIListener(a2.mBookletUIListener);
        a2.configureChromeSearchBar();
    }

    protected void configureChromeSearchBar() {
        DCBooklet a;
        ChromeSearchBarButton[] chromeSearchBarButtonArray = new ChromeSearchBarButton[1];
        ChromeSearchBarButton[] a2 = chromeSearchBarButtonArray;
        chromeSearchBarButtonArray[0] = new ChromeSearchBarButton("store", null, "system");
        a.mChromeHeaderRequest.getSearchRequest().setProfile("default", a2);
    }

    public void start(URI a) {
        DCBooklet a2;
        a2.mCurrentContent = a;
        if (a2.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a2.isActive()) {
            a2.loadView(a2.mCurrentContent);
        } else {
            ((AmazonRegistrationService)a2.mBookletContext.getService(AmazonRegistrationService.class)).addRegistrationListener(a2.mRegistrationListener);
            BehaviorUtils.loadBehaviors(a2.getBehaviors());
        }
        BookletStartEvent.getInstance().fireEvent(a);
        super.start(a);
        a2.mChromeHeaderRequest.setPrimaryTitle(CommunicationUtils.getDeviceName((Booklet)a2));
    }

    protected void loadView(URI a) {
        DCBooklet a2;
        if (a == null) {
            return;
        }
        final Map a3 = BookletUtils.parseUri(a);
        if (SwingUtilities.isEventDispatchThread()) {
            a2.doLoadView(a3);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    a.DCBooklet.this.doLoadView(a.a3);
                }
            });
        }
    }

    protected void doLoadView(Map a) {
        DCBooklet a2;
        DisplayController a3 = a2.getDisplayControllerFromMap(a);
        if (a3 != null) {
            a3.loadHistory(a);
            a2.loadBaseView(a3, null, false);
        } else {
            a2.loadBaseView(a2.getDefaultController(), null, false);
        }
        a2.mapGlobalGestures();
    }

    protected DisplayController getDisplayControllerFromMap(Map a) {
        if (a != null && a.get(HISTORY_PARAM_VIEW) != null) {
            DCBooklet a2;
            String a3 = (String)a.get(HISTORY_PARAM_VIEW);
            DisplayController a4 = a2.getDisplayController(a3);
            if (a4 != null) {
                return a4;
            }
            return a2.recreateDisplayController(a3);
        }
        return null;
    }

    public void stop() {
        DCBooklet a;
        if (a.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.stop();
        ((AmazonRegistrationService)a.mBookletContext.getService(AmazonRegistrationService.class)).removeRegistrationListener(a.mRegistrationListener);
        BehaviorUtils.unloadBehaviors(a.getBehaviors());
    }

    public void destroy() {
        DCBooklet a;
        if (a.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        a.stop();
        a.mBookletContext.removeUIListener(a.mBookletUIListener);
        super.destroy();
    }

    public DisplayController getActiveController() {
        DCBooklet a;
        return a.mActiveController;
    }

    public void loadBaseView(DisplayController a, Object a2, boolean a3) {
        DCBooklet a4;
        if (a4.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a != null) {
            KindleFrameFactory.cleanUpApplicationDialogs((String)a4.getName());
            a4.unloadActiveView(a3);
            a4.mActiveController = a;
            a4.mActiveController.willLoad();
            a4.mActiveController.loadData(a2);
            Container a5 = a4.mBookletContext.getUIContainer();
            PreLoadViewEvent.getInstance().fireEvent(a2);
            a4.mActiveController.load();
            a5.removeAll();
            a5.add(a4.mActiveController.getPanel());
            a5.validate();
            a5.repaint();
            PostLoadViewEvent.getInstance().fireEvent();
        } else {
            LOG.error(SWITCH_CONTROLLER_ERR, new String[]{a4.mBookletContext.getName(), a4.mActiveController.getViewKey(), "null"}, "");
        }
    }

    public void loadPreviousView() {
        DCBooklet a;
        if (a.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        History a2 = (History)a.mBookletContext.getService(History.class);
        try {
            a2.back();
        }
        catch (HistoryException a3) {
            LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a3);
        }
    }

    protected void unloadActiveView(boolean a) {
        DCBooklet a2;
        if (a2.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a2.mActiveController != null) {
            if (a) {
                a2.markHistory();
            }
            a2.mActiveController.willUnload();
            a2.mBookletContext.getUIContainer().remove(a2.mActiveController.getPanel());
            a2.mActiveController.unload();
            a2.mActiveController = null;
        }
    }

    public ActionManager getActionManager() {
        DCBooklet a;
        return a.mActionManager;
    }

    public void markHistory() {
        DCBooklet a;
        if (a.mActiveController == null) {
            return;
        }
        try {
            if (a.mBookletContext == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            History a2 = (History)a.mBookletContext.getService(History.class);
            if (a2 != null) {
                HashMap<String, String> a3 = new HashMap<String, String>();
                String a4 = a.mActiveController.getViewKey();
                a3.put(HISTORY_PARAM_VIEW, a4);
                a.mActiveController.addHistoryState(a3);
                a2.pushMark((Booklet)a, a3);
            }
        }
        catch (HistoryException a5) {
            LOG.error(HISTORY_PUSH_ERR, new String[]{a.mBookletContext.getName()}, "Can't save history state");
        }
    }

    public synchronized void updateChromeHeaderText() {
        DCBooklet a;
        a.mChromeHeaderRequest.setTitles(CommunicationUtils.getDeviceName((Booklet)a), "", null, false);
        try {
            a.syncHeaderRequest();
        }
        catch (ChromeException a2) {
            LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a2);
        }
    }

    public void updateChromeHeaderBarMenuAction() {
        DCBooklet a;
        if (a.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        ChromeHeaderBar a2 = (ChromeHeaderBar)a.mBookletContext.getService(ChromeHeaderBar.class);
        if (a2 != null) {
            try {
                a2.setSearchBarButtonSelectedListener(a.mBookletContext, (ActionListener)a.mMenuButtonListener);
            }
            catch (ChromeException a3) {
                LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a3);
            }
        }
    }

    protected void mapGlobalGestures() {
        DCBooklet a;
        if (a.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a.mGestureMap == null) {
            a.mGestureMap = new ActionMap();
            AbstractAction a2 = new AbstractAction(){
                {
                    2 a;
                }

                public void actionPerformed(ActionEvent a) {
                    2 a2;
                    if (a2.DCBooklet.this.mActiveController != null) {
                        a2.DCBooklet.this.mActiveController.nextPage();
                        PageTurnEvent.getInstance().fireEvent();
                    }
                }
            };
            AbstractAction a3 = new AbstractAction(){
                {
                    3 a;
                }

                public void actionPerformed(ActionEvent a) {
                    3 a2;
                    if (a2.DCBooklet.this.mActiveController != null) {
                        a2.DCBooklet.this.mActiveController.prevPage();
                        PageTurnEvent.getInstance().fireEvent();
                    }
                }
            };
            a.mGestureMap.put("east", a3);
            a.mGestureMap.put("south", a3);
            a.mGestureMap.put("west", a2);
            a.mGestureMap.put("north", a2);
        }
        a.mBookletContext.setGestureActionMap(a.mGestureMap);
    }

    public synchronized void addDisplayController(String a, DisplayController a2) {
        DCBooklet a3;
        a3.addDisplayController(a, a2, false);
    }

    public synchronized void addDisplayController(String a, DisplayController a2, boolean a3) {
        DCBooklet a4;
        a4.mViewCache.put(new String(a), a3 ? a2 : new SoftReference<DisplayController>(a2));
    }

    public DisplayController getDisplayController(String a) {
        DCBooklet a2;
        if (a2.mViewCache.containsKey(a)) {
            Object a3 = a2.mViewCache.get(a);
            if (a3 instanceof SoftReference) {
                a3 = ((SoftReference)a3).get();
            }
            if (a3 instanceof DisplayController) {
                return (DisplayController)a3;
            }
            return null;
        }
        return null;
    }

    protected abstract DisplayController recreateDisplayController(String var1);

    public synchronized BookletBehavior[] getBehaviors() {
        return null;
    }

    public abstract DisplayController getDefaultController();

    private class DefaultBookletUIListener
    implements BookletUIListener {
        private DefaultBookletUIListener() {
            DefaultBookletUIListener a;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onUIContainerStateChange(BookletUIEvent a) {
            switch (a.getEvent()) {
                case 3: {
                    DefaultBookletUIListener a2;
                    a2.DCBooklet.this.updateChromeHeaderBarMenuAction();
                    return;
                }
                case 1: {
                    DefaultBookletUIListener a2;
                    a2.DCBooklet.this.loadView(a2.DCBooklet.this.mCurrentContent);
                    return;
                }
                case 2: {
                    DefaultBookletUIListener a2;
                    a2.DCBooklet.this.unloadActiveView(a2.DCBooklet.this.mActiveController != null ? a2.DCBooklet.this.mActiveController.shouldMarkHistory() : false);
                    return;
                }
            }
        }
    }

    private class DefaultRegistrationListener
    implements RegistrationListener {
        private DefaultRegistrationListener() {
            DefaultRegistrationListener a;
        }

        public void onRegistrationInfoChanged(RegistrationEvent a) {
            RegistrationEvent.RegistrationEventType a2 = a.getEventType();
            if (a2.equals((Object)RegistrationEvent.RegistrationEventType.REGISTERED) || a2.equals((Object)RegistrationEvent.RegistrationEventType.DEREGISTERED) || a2.equals((Object)RegistrationEvent.RegistrationEventType.DEVICE_NAME_CHANGED)) {
                DefaultRegistrationListener a3;
                a3.DCBooklet.this.updateChromeHeaderText();
            }
        }
    }

    private class MenuButtonActionListener
    implements ActionListener {
        private MenuButtonActionListener() {
            MenuButtonActionListener a;
        }

        public void actionPerformed(ActionEvent a) {
            MenuButtonActionListener a2;
            a2.debugLog("ActionEvent:Start:ActionCommand=" + a.getActionCommand());
            if (a.getActionCommand().equals("menu")) {
                boolean a3 = false;
                if (a2.DCBooklet.this.mActiveController != null && !a2.DCBooklet.this.mActiveMenuVisible) {
                    a3 = true;
                    a2.DCBooklet.this.mActiveMenuVisible = true;
                } else {
                    if (a2.DCBooklet.this.mActiveController == null) {
                        a2.debugLog("Null Active Controller");
                    }
                    if (a2.DCBooklet.this.mActiveMenuVisible) {
                        a2.debugLog("Menu Visibility Flag=true expected false");
                    }
                }
                if (a3 && GestureDispatchUtils.isReady()) {
                    MenuDialog a4 = a2.DCBooklet.this.mActiveController.getMenu();
                    if (a4 != null) {
                        a4.postDialog(true);
                    } else {
                        a2.debugLog("Null Active Controller Menu");
                    }
                } else if (!a3) {
                    a2.debugLog("Post Menu Flag=false; Expected true");
                } else {
                    a2.debugLog("Ignore Menu Request: Time Since Last Tap <= 700ms");
                }
                a2.DCBooklet.this.mActiveMenuVisible = false;
                a2.debugLog("Reset menu visibility flag to false");
            }
            a2.debugLog("ActionEvent:Stop:ActionCommand=" + a.getActionCommand());
        }

        private void debugLog(String a) {
            if (Log.isDebugOn()) {
                MenuButtonActionListener a2;
                if (a2.DCBooklet.this.mBookletContext == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                LOG.debug(MENU_TAP_LOG, new String[]{a2.DCBooklet.this.mBookletContext.getName()}, a);
            }
        }
    }
}

