/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control;

import com.amazon.agui.swing.HeaderBar;
import com.amazon.agui.swing.IndexedListRendererFactory;
import com.amazon.agui.swing.InteractiveList;
import com.amazon.agui.swing.ListCursorChangeListener;
import com.amazon.agui.swing.MenuDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.ListBasedDisplayController;
import com.amazon.kindle.control.content.ContentManager;
import com.amazon.kindle.control.dialog.GoToPageDialog;
import com.amazon.kindle.control.listener.DefaultCursorListener;
import com.amazon.kindle.control.listener.DefaultModelListener;
import com.amazon.kindle.control.menu.MenuItemFactory;
import com.amazon.kindle.control.menu.SortMenuDialog;
import com.amazon.kindle.control.util.BookletUtils;
import com.amazon.kindle.control.util.PageUtils;
import com.amazon.kindle.control.util.SortUtils;
import com.amazon.kindle.control.widget.InteractiveListWrapper;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;

public abstract class ContentBasedDisplayController
extends ListBasedDisplayController {
    public static final String l = "index";
    public static final int k = 3;
    private static final Log m = Log.getInstance((String)"ContentBasedDisplayController");
    protected InteractiveListWrapper h;
    protected ContentManager A;
    private ListDataListener H;
    private ListCursorChangeListener b;
    private int K = 0;
    private boolean B;
    private HeaderBar.HeaderListener D;

    public ContentBasedDisplayController(DCBooklet a) {
        super(a);
        ContentBasedDisplayController a2;
        a2.D = new HeaderBar.HeaderListener(){
            {
                1 a;
            }

            public void onTapText(int a) {
                1 a2;
                if (a == 1) {
                    SortMenuDialog a3 = new SortMenuDialog(a2.ContentBasedDisplayController.this);
                    a3.postDialog();
                } else if (a == 2) {
                    GoToPageDialog a4 = new GoToPageDialog(a2.ContentBasedDisplayController.this);
                    a4.postDialog();
                }
            }
        };
    }

    public void switchTo(Object a) {
        ContentBasedDisplayController a2;
        a2.K = 0;
        super.switchTo(a);
    }

    public JPanel getPanel() {
        ContentBasedDisplayController a;
        return a.h;
    }

    public void updateHeader() {
        ContentBasedDisplayController a;
        JPanel a2 = a.getPanel();
        if (a2 instanceof InteractiveListWrapper) {
            ((InteractiveListWrapper)a2).setHeaderText(a.getContentLabel(), a.getContentCountLabel(), a.getSortLabel(), a.getPageLabel());
        }
    }

    public String getContentLabel() {
        return null;
    }

    public String getContentCountLabel() {
        return null;
    }

    protected String getPageLabel() {
        InteractiveList a;
        ContentBasedDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.DisplayControllerResources");
        int a4 = a2.A.getSize();
        int a5 = a2.A.getCursor();
        if (a4 < 0) {
            m.error("interactive list size can't be negative number");
            return a3.getString("page.noitems");
        }
        if (a4 == 0) {
            return a3.getString("page.noitems");
        }
        JPanel a6 = a2.getPanel();
        int a7 = 0;
        if (a6 != null && a6 instanceof InteractiveListWrapper && (a = ((InteractiveListWrapper)a6).getInteractiveList()) != null) {
            a7 = a.getPageItemCount();
        }
        return MessageFormat.format(a3.getString("page.template"), new Integer(PageUtils.getCurrentPageNumber(a5, a7)), new Integer(PageUtils.getTotalPageNumber(a4, a7)));
    }

    protected String getSortLabel() {
        ContentBasedDisplayController a;
        String a2 = SortUtils.getSortOptionKey(a.getContentManager().getSortOption(), a.getContentManager().getDefaultSortOption());
        if (StringUtil.isNotEmpty((String)a2)) {
            try {
                ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.DisplayControllerResources");
                return MessageFormat.format(a3.getString("sort.template"), a3.getString("sort.label." + a2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void load() {
        ContentBasedDisplayController a;
        super.load();
        if (a.A == null) {
            a.initContentManager();
        } else {
            a.A.setAutoUpdateEnabled(true);
        }
        if (a.h == null || a.B) {
            a.initPanel();
            a.B = false;
        }
        a.h.addHeaderListener(a.D);
        try {
            a.A.setCursor(a.K);
        }
        catch (IllegalArgumentException a2) {
            m.error("setCursor out of range. Resetting to zero ", (Throwable)a2);
            a.K = 0;
            a.A.setCursor(a.K);
        }
    }

    public void refreshView() {
        a.B = true;
    }

    protected void initContentManager() {
        ContentBasedDisplayController a;
        int a2 = (Integer)ResourceBundle.getBundle("com.amazon.kindle.control.resources.DisplayControllerResources").getObject("numrows.portrait");
        a.A = a.getNewContentManager(a2);
    }

    public void unload() {
        ContentBasedDisplayController a;
        super.unload();
        if (a.A != null) {
            a.A.setAutoUpdateEnabled(false);
        }
        if (a.h != null) {
            a.h.removeHeaderListener(a.D);
        }
    }

    public ContentManager getContentManager() {
        ContentBasedDisplayController a;
        return a.A;
    }

    public void loadHistory(Map a) {
        Object a2;
        if (a != null && (a2 = a.get(l)) != null && a2 instanceof String) {
            try {
                a.K = Integer.parseInt((String)a2);
            }
            catch (NumberFormatException a3) {
                m.error("Failed to parse history param ", (Throwable)a3);
                a.K = 0;
            }
        }
    }

    public void nextPage() {
        ContentBasedDisplayController a;
        a.delta(true);
    }

    public void prevPage() {
        ContentBasedDisplayController a;
        a.delta(false);
    }

    private void delta(boolean a) {
        ContentBasedDisplayController a2;
        BookletUtils.page(a2.booklet, a2.h, a);
    }

    public synchronized ListDataListener getListDataListener() {
        ContentBasedDisplayController a;
        if (a.H == null) {
            a.H = new DefaultModelListener();
        }
        return a.H;
    }

    public synchronized ListCursorChangeListener getCursorListener() {
        ContentBasedDisplayController a;
        if (a.b == null) {
            a.b = new DefaultCursorListener();
        }
        return a.b;
    }

    public void addHistoryState(Map a) {
        ContentBasedDisplayController a2;
        if (a2.A != null && a2.A.getCursor() >= 0) {
            a.put(l, new Integer(a2.A.getCursor()));
        }
    }

    protected synchronized void initPanel() {
        ContentBasedDisplayController a;
        a.h = new InteractiveListWrapper(a.createInteractiveList());
    }

    public synchronized MenuDialog getMenu() {
        ContentBasedDisplayController a;
        MenuDialog a2 = super.getMenu();
        a2.addActionWithIndicator(MenuItemFactory.getSortActionItem(a.getBooklet()));
        return a2;
    }

    protected abstract IndexedListRendererFactory getRendererFactory();

    protected abstract InteractiveList createInteractiveList();

    protected abstract ContentManager getNewContentManager(int var1);
}

