package org.amoth.GUI;

import org.amoth.action.ActiveAutoCollectionAction;
import org.amoth.action.ActiveRecentlyRead;
import org.amoth.action.UnactiveAutoCollectionAction;
import org.amoth.action.UnactiveRecentlyRead;
import org.amoth.business.DBRequest;


public class TweakScreen extends Screen {

	private String letter = "";
	

	@Override
	protected String getTitle() {
		return "Tweak";
	}

	@Override
	protected void buildActionList() {
		DBRequest db = new DBRequest();
		if (db.isAutoCollectionActive(this.letter))
			this.actionList.add(new UnactiveAutoCollectionAction(this.letter, "1", "Unactive Auto Collection (currently on)"));
		else
			this.actionList.add(new ActiveAutoCollectionAction(this.letter, "1", "Active Auto Collection (currently off)"));
		
		if (db.isRecentlyReadActive(this.letter))
			this.actionList.add(new UnactiveRecentlyRead(this.letter, "2", "Unactive Recently read (currently on)"));
		else
			this.actionList.add(new ActiveRecentlyRead(this.letter, "2", "Active Recently read (currently off)"));
		
	}

	@Override
	protected String getComment() {
		
		return "Selected Drive: " + this.letter;
	}

	@Override
	protected String getPromp() {
		
		return "Choose your action: ";
	}


	public String getLetter() {
		return this.letter;
	}

	public TweakScreen(String letter) {
		super();
		this.letter = letter;
	}

}
