package org.amoth.GUI;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import javax.swing.filechooser.FileSystemView;

import org.amoth.action.CreateDriveAction;

public class OpenScreen extends Screen {

	@Override
	protected String getTitle() {
		return "Open an existing Database";
	}

	@Override
	protected void buildActionList() {
		List<File> files = Arrays.asList(File.listRoots());
		for (File f : files) {
			File file = new File(f.getAbsolutePath()
					+ "Sony_Reader\\database\\books.db");
			if (file.exists()) {

				this.actionList.add(new CreateDriveAction(f.getAbsolutePath()
						.substring(0, 1), FileSystemView.getFileSystemView()
						.getSystemTypeDescription(f)
						+ " / "
						+ FileSystemView.getFileSystemView()
								.getSystemDisplayName(f)));
			}
		}

	}

	@Override
	protected String getComment() {
		if (this.actionList.size() == 0)
			return "Available Drives:\r\n\r\n    There is no available drive!";
		return "Available drives:";
	}

	@Override
	protected String getPromp() {
		return "Which database do you want to open:";
	}

}