from __future__ import with_statement
__license__ = 'GPL 3'
__copyright__ = '2012, Robert Pourteau <RPourteau@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre.customize.profiles import OutputProfile

class CruzT408(OutputProfile):

    author      = 'Robert Pourteau'
    name        = 'Cruz T408'
    short_name  = 'cruzt408'
    description = _('This profile is intended for the Velocity Micro Cruz T408 Tablet.')

    # Screen size is a best guess
    screen_size               = (600, 800)
    comic_screen_size         = (550, 800)

output_profiles = [CruzT408]

output_profiles.sort(cmp=lambda x,y:cmp(x.name.lower(), y.name.lower()))