from __future__ import with_statement
__license__ = 'GPL 3'
__copyright__ = '2012, Robert Pourteau <RPourteau@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre.customize.profiles import OutputProfile

class CruzR101(OutputProfile):

    author      = 'Robert Pourteau'
    name        = 'Cruz R101'
    short_name  = 'cruzr101'
    description = _('This profile is intended for the Velocity Micro Cruz R101 Reader.')

    # Screen size is a best guess
    screen_size               = (600, 800)
    comic_screen_size         = (550, 800)

output_profiles = [CruzR101]

output_profiles.sort(cmp=lambda x,y:cmp(x.name.lower(), y.name.lower()))