import os, glob, collections, sys

all_lngs = set([os.path.splitext(os.path.split(x)[1])[0] for x in glob.glob('*/*.properties')])
print 'Found languages:',
if all_lngs:
    print ', '.join(list(all_lngs))
else:
    print 'nothing... wrong folder?'
    sys.exit(1)

source = 'en_US'
try:
    all_lngs.remove(source)
except:
    print 'Source language (%s) not found. Download it from Transifex e.g. by "tx pull -s"' % source
    sys.exit(1)

usage = 'Usage: %s <model-language>\n  This would compare all other languages against [%s==<model_language>] and generate reports\n  Available model languages are:\n  * %s' % \
        (sys.argv[0], source, '\n  * '.join(list(all_lngs)))
if len(sys.argv) != 2:
    print usage
    sys.exit(1)
model = sys.argv[1]
if model not in all_lngs:
    print 'Wrong model language!'
    print usage
    sys.exit(1)
all_lngs.remove(model)

def load_prop(path):
    data = []
    with open(path, 'r') as f:
        for line in f.xreadlines():
            pair = line.strip().split('=', 1)
            if len(pair) == 2:
                data.append(pair)
    return dict(data)

def get_equal(d1, d2):
    result = set()
    for k in (set(d1.keys()) & set(d2.keys())):
        if d1[k] == d2[k]:
            result.add(k)
    return result

def load_lang(lng):
    res = {}
    for f in glob.glob('*/%s.properties' % lng):
        res[os.path.split(f)[0]] = load_prop(f)
    return res

src_data, mod_data = [load_lang(x) for x in (source, model)]
lng_data = {}

report = {}
for lng in all_lngs:
    report[lng] = {}
    lng_data[lng] = load_lang(lng)
    for folder in (set(src_data.keys()) | set(mod_data.keys()) | set(lng_data[lng].keys())):
        mod_eq, lng_eq = [get_equal(src_data.get(folder, {}), x.get(folder, {})) for x in (mod_data, lng_data[lng])]
        bad = mod_eq - lng_eq # stuff identical in model-source, but not identical in lng-source
        bad = [x for x in bad if lng_data[lng].get(folder, {}).get(x, '')]
        if bad: report[lng][folder] = bad

def get_get(d, k1, k2, dflt):
    try:
        return d[k1][k2]
    except:
        return dflt
def get_prop(lng, folder, name):
    return name, get_get(lng_data[lng], folder, name, 'N/A'), get_get(src_data, folder, name, 'N/A')

if not os.path.exists('report'):
    os.mkdir('report')

for lng, data in report.iteritems():
    if not data: continue
    with open(os.path.join('report', '%s.html' % lng), 'w') as out:
        out.write('<html>\n<head>\n<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />\n</head>\n<body>\n' + \
                  '<table border=1>\n<tr><td>folder</td><td>property</td><td>%s</td><td>%s</td></tr>\n' % (lng, source))
        for folder, props in data.iteritems():
             out.write('<tr><td rowspan="%d">%s</td><td>%s</td><td>&nbsp;%s</td><td>&nbsp;%s</td></tr>\n' % ((len(props), folder) + get_prop(lng, folder, props[0])))
             for item in props[1:]:
                 out.write('<tr><td>%s</td><td>&nbsp;%s</td><td>&nbsp;%s</td></tr>\n' % get_prop(lng, folder, item))
        out.write('</table>\n</body>\n</html>\n')
        out.close()

