#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_python26/install

cd $THISDIR

backup_firmware () {
    # Save originals ONLY if they do not exists
    if [ ! -e $THISDIR/liberutils_original ]
    then
        /bin/cp -f /usr/lib/liberutils.so.0.0.1 $THISDIR/liberutils_original
    fi
}

install_patched_files () {
    # overwrite existing files
    /bin/cp -f $THISDIR/liberutils.so.0.0.1 /usr/lib/
}

restore_original_files () {
    # Restore the original program(s)
    if [ -e $THISDIR/liberutils_original ]
    then
        /bin/cp $THISDIR/liberutils_original /usr/lib/liberutils.so.0.0.1
        /bin/rm -f $THISDIR/liberutils_original
    fi
}

	# first backup original programs, only if they don't exist
	if [ ! -f $THISDIR/liberutils_original ]; then
		echo "Backing-up original firmware files"
		backup_firmware
	fi
	# install patches files
	install_patched_files

    # For the new version to be used, a reset is needed
	# Do not show a dialog, the new libraries will crash the DR when they are used ...
    /sbin/reboot
    sleep 31
fi
    