import pygtk
pygtk.require('2.0')
import gtk, gobject, glib, cairo, pango

import erapp
from sheet import *
import erutils

#gtk.pygtk_version
#gtk.gtk_version

APP_NAME = "Calc"
APP_VERSION = "0.4"

class CommandArea(gtk.HBox):
    def __init__(self):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0

        # HOME
        self.btn_home = gtk.Button()
        self.btn_home.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_HOME, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_home.set_image(image)
        self.btn_home.connect("clicked", lambda w: app.go_home())
        self.pack_start(self.btn_home, False, False, 0)

        # LEFT
        self.btn_left = gtk.Button()
        self.btn_left.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_BACK, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_left.set_image(image)
        self.btn_left.connect("clicked", lambda w: app.go_left(1))
        self.pack_start(self.btn_left, False, False, 0)

        # RIGHT
        self.btn_right = gtk.Button()
        self.btn_right.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_FORWARD, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_right.set_image(image)
        self.btn_right.connect("clicked", lambda w: app.go_right(1))
        self.pack_start(self.btn_right, False, False, 0)

        # DOWN
        self.btn_down = gtk.Button()
        self.btn_down.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_DOWN, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_down.set_image(image)
        self.btn_down.connect("clicked", lambda w: app.go_down(1))
        self.pack_start(self.btn_down, False, False, 0)

        # UP
        self.btn_up = gtk.Button()
        self.btn_up.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_GO_UP, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_up.set_image(image)
        self.btn_up.connect("clicked", lambda w: app.go_up(1))
        self.pack_start(self.btn_up, False, False, 0)

        # LOAD
        self.btn_load = gtk.Button()
        self.btn_load.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_load.set_image(image)
        self.btn_load.connect("clicked", lambda w: app.do_load())
        self.pack_start(self.btn_load, False, False, 0)

        # CLOSE
        self.btn_close = gtk.Button()
        self.btn_close.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_STOP, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_close.set_image(image)
        self.btn_close.connect("clicked", lambda w: app.do_close())
        self.pack_end(self.btn_close, False, False, 0)


class CellArea(gtk.DrawingArea):
    # Signal handlers
    __gsignals__ = { "configure-event": "override",
                     "expose-event": "override",
                     "button-press-event": "override"}

    def __init__(self):
        gtk.DrawingArea.__init__(self)
        self.set_double_buffered(False)
        self.set_app_paintable(True)
        self.add_events(gtk.gdk.BUTTON_PRESS_MASK)
        self.col_width_list = None
        self.row_height_list = None
        self.start_x = 0
        self.start_y = 0
        # Need to set the size for Simulation
        self.set_size_request(700, 900)

    def do_configure_event(self, ev):
        self.width = ev.width
        self.height = ev.height
        return True

    def do_expose_event(self, ev):
        ctx = self.window.cairo_create()
        ctx.set_source_rgb(1.0, 1.0, 1.0)
        ctx.set_operator(cairo.OPERATOR_SOURCE)
        ctx.paint()
        # get sheet
        sheet = app.get_sheet(0)
        # draw the headers
        ## width of left size header and height of top header
        header_height = sheet.get_col_properties().find_property('header-height')
        self.header_height = header_height
        header_width = sheet.get_row_properties().find_property('header-width')
        self.header_width = header_width
        
        ## get column sizes
        col_width_list = sheet.get_col_widths(header_width, self.width)
        self.nr_cols = len(col_width_list)
        if self.col_width_list != None:
            del self.col_width_list
        self.col_width_list = col_width_list
        
        ## get row sizes
        row_height_list = sheet.get_row_heights(header_height, self.height) 
        self.nr_rows = len(row_height_list)
        if self.row_height_list != None:
            del self.row_height_list
        self.row_height_list = row_height_list
        #print "cols=%d rows=%d" %(self.nr_cols, self.nr_rows)
        
        # and draw them
        self.draw_col_header(ctx, header_width, 0,
                             self.width-header_width, header_height,
                             col_width_list, self.start_x)
        self.draw_row_header(ctx, 0, header_height,
                             header_width, self.height-header_height,
                             row_height_list, self.start_y)
        self.draw_cell_borders(ctx, header_width, header_height,
                               self.width-header_width, self.height-header_height,
                               col_width_list, row_height_list)
        self.draw_cells(ctx, header_width, header_height,
                        self.width-header_width, self.height-header_height,
                        col_width_list, row_height_list, sheet,
                        self.start_x, self.start_y)
        return True

    def do_button_press_event(self, ev):
        #print "Position: %dx%d" % (ev.x, ev.y)
        x = self.header_width
        col = -1
        if x <= ev.x:
            col = 0
            for col_w in self.col_width_list:
                if x + col_w > ev.x:
                    break
                col += 1
                x += col_w

        y = self.header_height
        row = -1
        if y <= ev.y:
            row = 0
            for row_h in self.row_height_list:
                if y + row_h > ev.y:
                    break
                row += 1
                y += row_h

        print "Cell (%d,%d)" % (col, row)
        return True
    
    def draw_col_header(self, ctx, x, y, w, h, col_width_list, start):
        # draw properties
        ctx.set_source_rgb(0.0, 0.0, 0.0)
        ctx.set_line_width(2.0)
        ctx.set_line_join(cairo.LINE_JOIN_ROUND)
        ctx.select_font_face("Times",
            cairo.FONT_SLANT_NORMAL)
        ctx.set_font_size(16)
        # determine number of columns that fit
        col = start
        col_names = "ABCDEFGHIJKLMNOPQRSTUVW"
        sum_width = 0
        for col_w in col_width_list:
            ctx.rectangle(x + sum_width, y, col_w, h)
            ctx.stroke()
            x_bearing, y_bearing, width, height = ctx.text_extents(col_names[col])[:4]
            # position: center of cell: x + sum_width + col_w / 2, h/2
            ctx.move_to(x + sum_width + col_w / 2 - width/2 - x_bearing,
                        h/2 - height/2 - y_bearing)
            ctx.show_text(col_names[col])
            sum_width += col_w
            col += 1

    def draw_row_header(self, ctx, x, y, w, h, row_height_list, start):
        # draw properties
        ctx.set_source_rgb(0.0, 0.0, 0.0)
        ctx.set_line_width(2.0)
        ctx.set_line_join(cairo.LINE_JOIN_ROUND)
        ctx.select_font_face("Times",
            cairo.FONT_SLANT_NORMAL)
        ctx.set_font_size(16)
        # determine number of rows that fit
        row = start
        sum_height = 0
        for row_h in row_height_list:
            ctx.rectangle(x, y + sum_height, w, row_h)
            ctx.stroke()
            row_name = str(row+1)
            x_bearing, y_bearing, width, height = ctx.text_extents(row_name)[:4]
            # position: center of cell: x + w/2, y + sum_height + row_h/2
            ctx.move_to(x + w/2 - width/2 - x_bearing,
                        y + sum_height + row_h/2 - height/2 - y_bearing)
            ctx.show_text(row_name)
            sum_height += row_h
            row += 1
            
    def draw_cell_borders(self, ctx, x, y, w, h, col_width_list, row_height_list):
        # draw properties
        ctx.set_source_rgb(0.5, 0.5, 0.5)
        ctx.set_line_width(1.0)
        # columns
        sum_width = x
        for col_w in col_width_list:
            sum_width += col_w
            ctx.move_to(sum_width, y)
            ctx.line_to(sum_width, y+h)
        ctx.stroke()
        # rows
        sum_height = y
        for row_h in row_height_list:
            sum_height += row_h
            ctx.move_to(x, sum_height)
            ctx.line_to(x+w, sum_height)
        ctx.stroke()

    def draw_cells(self, ctx, x, y, w, h, col_width_list, row_height_list, sheet, start_x, start_y):
        # draw properties
        ctx.set_source_rgb(0.0, 0.0, 0.0)
        ctx.set_line_width(2.0)
        ctx.set_line_join(cairo.LINE_JOIN_ROUND)
        ctx.select_font_face("Times",
            cairo.FONT_SLANT_NORMAL)
        ctx.set_font_size(16)
        # determine number of rows that fit
        sum_height = y
        row_nr = start_y
        for row_h in row_height_list:
            sum_width = x
            col_nr = start_x
            for col_w in col_width_list:
                cell = sheet.get_cell(col_nr, row_nr)
                if cell != None:
                    text = cell.get_value()
                    x_bearing, y_bearing, width, height = ctx.text_extents(text)[:4]
                    # position: left of cell:
                    ctx.move_to(x + sum_width + 1 - width/2 - x_bearing,
                                y + sum_height + row_h/2 - height/2 - y_bearing)
                    ctx.show_text(text)
                sum_width += col_w
                col_nr += 1
            sum_height += row_h
            row_nr += 1
                    
    def do_left(self, step):
        self.start_x -= step
        if self.start_x < 0:
            self.start_x = 0
        self.update()

    def do_right(self, step):
        self.start_x += step
        if self.start_x > 20:
            # limit scrolling
            self.start_x = 20
        self.update()

    def do_up(self, step):
        self.start_y -= step
        if self.start_y < 0:
            self.start_y = 0
        self.update()

    def do_down(self, step):
        self.start_y += step
        if self.start_y > 1000:
            # limit scrolling
            self.start_y = 1000
        self.update()

    def do_goto(self, x, y):
        self.start_x = x
        self.start_y = y
        self.update()

    def update(self):
        #if not self.get_realized():
        #    print "Not yet realized"
        #    return
        print "update"
        self.do_expose_event(None)
        app.refresh()

class StatusArea(gtk.HBox):
    def __init__(self):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        self.set_size_request(-1, 20)
        self.hdr = gtk.Label("")
        #self.hdr.set_markup("<b><span size='xx-large'>Status Area</span></b>")
        self.hdr.set_text("Calc")
        self.pack_start(self.hdr, True, True, 10)

    def update(self):
        # the old fashion force update
        self.hdr.set_text("Calc")

class AppWindow(gtk.VBox):
    def __init__(self):
        gtk.VBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        # Command Area
        self.command_area = CommandArea()
        self.pack_start(self.command_area, False, False, 0)
        # Cell Area
        self.cell_area = CellArea()
        self.pack_start(self.cell_area, True, True, 0)
        # Status Area
        self.status_area = StatusArea()
        self.pack_start(self.status_area, False, False, 0)

def on_send_startup_complete():
    try:
        win = app.window.xid
    except:
        # in simulator on x86 this does not work, so use substitue
        win = 1
    app.ipc.send_startup_complete(win)
    return False

class AppCalc(erapp.DrApplication, gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self)
        # display management
        self.erutils = erutils.ErUtils()
        self.have_control = False
        # create ui and dr specific stuff
        self.build_ui()
        self.build_dr()
        # announce that app is started (and can be added to task bar)
        glib.idle_add(on_send_startup_complete)
        # create an empty sheet
        self.sheet = Sheet('Sheet1')

    def get_sheet(self, nr):
        return self.sheet
    
    def build_ui(self):
        self.set_title("calc")
        self.connect("destroy", self.on_quit)
        self.connect("key-press-event", self.do_key_pressed_event)
        self.connect("key-release-event", self.do_key_released_event)
        # Create content
        self.app_win = AppWindow()
        self.add(self.app_win)
        self.show_all()

    def on_quit(self, widget):
        print "Quiting"
        gtk.main_quit()
        pass

    def do_key_pressed_event(self, widget, key):
        #print gtk.gdk.keyval_name(key.keyval)
        return True

    def do_key_released_event(self, widget, ev):
        keyname = gtk.gdk.keyval_name(ev.keyval)
        #print "Key-up: %d-%d%s" % (ev.state, ev.keyval, keyname)
        stepsize = 1
        if ev.state == gtk.gdk.SHIFT_MASK:
            stepsize *= 10
        if keyname == 'Left':
            self.go_left(stepsize)
        elif keyname == 'Right':
            self.go_right(stepsize)
        elif keyname == 'Up':
            self.go_up(stepsize)
        elif keyname == 'Down':
            self.go_down(stepsize)
        elif keyname == 'Page_Up':
            self.go_up(10*stepsize)
        elif keyname == 'Page_Down':
            self.go_down(10*stepsize)
        elif keyname == 'Home':
            self.go_home()
        elif keyname == 'End':
            print "End"
        elif keyname == 'BackSpace':
            print "BackSpace"
        # for simulation on PC
        elif keyname == 'a':
            self.do_about(APP_NAME, APP_VERSION)
        return True

    def build_dr(self):
        # For the name no spaces are allowed, only use lower case characters
        self.ipc = erapp.DrIpc("calc", "1.0", self);
        menu_manager = erapp.MenuManager(self.ipc);
        self.menu_manager = menu_manager
        # menu
        menu_main = erapp.Menu(menu_manager, "menumain", "Calc");
        self.menu_main = menu_main
        group_main = menu_main.addGroup("groupmain", "Main Buttons");

        group_main.addItem("close",       "Close",        "close");
        group_main.addItem("load",        "Load",         "open");
        group_main.addItem("about",       "About",        "info");
        menu_main.realise();

        # toolbar
        menu_manager.add_toolbar_item("calc_menumain", "calc_groupmain",  "close");
        menu_manager.add_toolbar_item("calc_menumain", "calc_groupmain",  "load");
        menu_manager.add_toolbar_item("calc_menumain", "calc_groupmain",  "about");
        
        menu_main.show();

    def onMenuClick(self, item, group, menu, state):
        # group in concatenation of ipc-name and group-name
        if group == "calc_groupmain":
            if item == "close":
                self.do_close()
            elif item == "load":
                self.do_load()
            elif item == "about":
                self.do_about(APP_NAME, APP_VERSION)

    def onFileOpen(self, filename):
        print 'onFileOpen'

    def onFileClose(self, filename):
        print 'onFileClose'

    def onWindowChange(self, xid, activated):
        if activated:
            # Need to change menu when we are activated again
            self.menu_main.show()

    def onPrepareUnmount(self, device):
        print 'onPrepareUnmount'

    def onUnmounted(self, device):
        print 'onUnmounted'

    def onMounted(self, device):
        print 'onMounted'

    def onPrepareHibernate(self):
        print 'onPrepareHibernate'

    def onChangeLocale(self, locale):
        print 'onChangeLocale'

    def onChangedOrientation(self, orientation):
        print 'onChangedOrientation'

    def getMainWindow(self):
        return self

    def go_left(self, step):
        self.app_win.cell_area.do_left(step)
        
    def go_right(self, step):
        self.app_win.cell_area.do_right(step)

    def go_up(self, step):
        self.app_win.cell_area.do_up(step)

    def go_down(self, step):
        self.app_win.cell_area.do_down(step)
        
    def go_home(self):
        self.app_win.cell_area.do_goto(0, 0)
        
    def do_close(self):
        self.on_quit(None)
        
    def do_load(self):
        filename = self.run_open_dialog()
        if filename != None:
            self.sheet.load_from_csv(filename)
        self.app_win.cell_area.update()

    def on_idle_display_yield(self):
        if self.have_control == True:
            self.erutils.display_update_return_control(1) # 1:DM_HINT_FULL, 4:DM_HINT_PARTIAL
            self.have_control = False
            print 'yield'
        
    def refresh(self):
        # helper function to force a refresh of the screen
        #self.app_win.status_area.update() # label trick
        if self.have_control == False:
            self.erutils.display_gain_control()
            self.have_control = True
            #glib.idle_add(self.on_idle_display_yield)
            glib.timeout_add(400, self.on_idle_display_yield)
        
    def dialog_default_size_changed_cb(self, widget, dialog):
        # this callback makes sure that the size of the dialog is big enough
        width = 700
        height = 700
        dialog.set_size_request(width, height)
        dialog.set_resizable(True)

    def dialog_response_requested_cb(self, widget, dialog):
        # This is used in xournal, but seems not to be required
        print "dialog_response_requested_cb"
    
    def dialog_file_activated_cb(self, widget, dialog):
        if dialog.activate_default():
            return
        # this should not be executed ...
        print  'dialog_file_activated_cb: no default'

    def do_about(self, name, version):
        dialog = gtk.Dialog("About", None,
                            gtk.DIALOG_DESTROY_WITH_PARENT,
                            (gtk.STOCK_OK, gtk.RESPONSE_OK))
        vbox = dialog.vbox

        # Application Name
        label = gtk.Label(name)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # Application Version
        ver_str = "\nVersion %s\n" % version
        label = gtk.Label(ver_str)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # create some space in the dialog
        label = gtk.Label("                                      ")
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        vbox.show()
        dialog.set_default_response(gtk.RESPONSE_OK)
        dialog.run()
        dialog.destroy()
        
    def run_open_dialog(self):
        dialog = gtk.Dialog( "Open..", None,
                             gtk.DIALOG_DESTROY_WITH_PARENT,
                             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                              gtk.STOCK_OPEN, gtk.RESPONSE_OK))
        dialog.set_has_separator(False)
        dialog.set_border_width(5)
        dialog.vbox.set_spacing(2)
        dialog.action_area.set_border_width(5)
        dialog.set_default_response(gtk.RESPONSE_OK)

        #dialog.connect("response", self.dialog_response_cb)
        widget = gtk.FileChooserWidget()
        widget.connect("file-activated", lambda w: self.dialog_file_activated_cb(w, dialog))
        widget.connect("default-size-changed", lambda w: self.dialog_default_size_changed_cb(w, dialog))
        widget.connect("response-requested", lambda w: self.dialog_response_requested_cb(w, dialog))

        widget.set_border_width(5)
        dialog.vbox.pack_start(widget, True, True, 0)

        filter = gtk.FileFilter()
        filter.set_name("csv files")
        filter.add_pattern("*.csv")
        widget.add_filter(filter)
        filter = gtk.FileFilter()
        filter.set_name("All files")
        filter.add_pattern("*")
        widget.add_filter(filter)

        widget.set_action(gtk.FILE_CHOOSER_ACTION_OPEN)

        widget.show()

        if dialog.run() != gtk.RESPONSE_OK:
            dialog.destroy()
            return None

        filename = widget.get_filename()
        dialog.destroy()

        return filename

        
app = AppCalc()
gtk.main()
