#!/bin/env python

"""
Python wrapper for liberipc
"""

import ctypes as C

try:
    # Load the Library
    erutils = C.cdll.LoadLibrary( 'liberutils.so.0' )
    erutils_simulated = False
except:
    # Could not load
    erutils = None
    erutils_simulated = True
    print "ERROR: could not load liberutils"

#------------------- Defines and typedefs -----------------

#------------------- Structures -----------------

#------------------- Functions -----------------

class ErUtils(object):
    def display_init(self):
        if erutils_simulated == False:
            erutils.display_init()

    def display_finialize(self):
        if erutils_simulated == False:
            erutils.display_finialize()

    def display_gain_control(self):
        if erutils_simulated == False:
            erutils.display_gain_control()

    def display_return_control(self):
        if erutils_simulated == False:
            erutils.display_return_control()

    def display_update_return_control(self, type):
        if erutils_simulated == False:
            erutils.display_update_return_control(type)

    def display_update_keep_control(self, type):
        if erutils_simulated == False:
            erutils.display_update_keep_control(type)

    def display_splash_lock(self):
        if erutils_simulated == False:
            erutils.display_splash_lock()

    def display_update_keep_splash_lock(self):
        if erutils_simulated == False:
            erutils.display_update_keep_splash_lock()

    def display_splash_unlock(self):
        if erutils_simulated == False:
            erutils.display_splash_unlock()
