import pygtk
pygtk.require('2.0')
import gtk, gobject, glib, cairo, pango

import erapp


APP_NAME = "Hello World"
APP_VERSION = "1.1"

def on_send_startup_complete():
    try:
        win = app.window.xid
    except:
        # in simulator on x86 this does not work, so use substitue
        win = 1
    app.ipc.send_startup_complete(win)
    return False

class AppWindow(gtk.VBox):
    def __init__(self):
        gtk.VBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        # size request needed for desktop
        self.set_size_request(700, 900)

        hdr = gtk.Label("")
        hdr.set_markup("<b><span size='xx-large'>Hello World</span></b>")
        self.pack_start(hdr, True, True, 10)

class MyApp(erapp.DrApplication, gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self)
        self.build_ui()
        self.build_dr()
        glib.idle_add(on_send_startup_complete)

    def build_ui(self):
        self.set_title("HelloWorld")
        self.connect("destroy", self.on_quit)
        self.connect("key-press-event", self.do_key_pressed_event)
        self.connect("key-release-event", self.do_key_released_event)
        # draw 'hello world'
        self.app_win = AppWindow()
        self.add(self.app_win)
        self.show_all()

    def on_quit(self, widget):
        print "Quiting"
        gtk.main_quit()
        pass

    def do_key_pressed_event(self, widget, key):
        #print gtk.gdk.keyval_name(key.keyval)
        return True

    def do_key_released_event(self, widget, ev):
        keyname = gtk.gdk.keyval_name(ev.keyval)
        #print "Key-up: %d-%d%s" % (ev.state, ev.keyval, keyname)
        if ev.state == gtk.gdk.SHIFT_MASK:
            pass
        if keyname == 'Left':
            print "Left"
        elif keyname == 'Right':
            print "Right"
        elif keyname == 'Up':
            print "Up"
        elif keyname == 'Down':
            print "Down"
        elif keyname == 'Page_Up':
            print "Page_Up"
        elif keyname == 'Page_Down':
            print "Page_Down"
        elif keyname == 'Home':
            print "Home"
        elif keyname == 'End':
            print "End"
        elif keyname == 'BackSpace':
            print "BackSpace"
        # for emulator
        elif keyname == 'c':
            self.do_close()
        elif keyname == 'a':
            self.do_about(APP_NAME, APP_VERSION)
        return True

    def build_dr(self):
        # For the name no spaces are allowed, only use lower case characters
        self.ipc = erapp.DrIpc("helloworld", "1.0", self);
        menu_manager = erapp.MenuManager(self.ipc);
        self.menu_manager = menu_manager
        # menu
        menu_main = erapp.Menu(menu_manager, "menumain", "HelloWorld");
        self.menu_main = menu_main
        group_main = menu_main.addGroup("groupmain", "Main Buttons");

        group_main.addItem("close",       "Close",        "close");
        group_main.addItem("about",       "About",        "info");
        menu_main.realise();

        # toolbar
        menu_manager.add_toolbar_item("helloworld_menumain", "helloworld_groupmain",  "close");
        menu_manager.add_toolbar_item("helloworld_menumain", "helloworld_groupmain",  "about");
        
        menu_main.show();

    def onMenuClick(self, item, group, menu, state):
        print 'onMenuClick'
        # group in concatenation of ipc-name and group-name
        if group == "helloworld_groupmain":
            if item == "close":
                self.do_close()
            elif item == "about":
                self.do_about(APP_NAME, APP_VERSION)

    def onFileOpen(self, filename):
        print 'onFileOpen'

    def onFileClose(self, filename):
        print 'onFileClose'

    def onWindowChange(self, xid, activated):
        print 'onWindowChange'
        if activated:
            self.menu_main.show()

    def onPrepareUnmount(self, device):
        print 'onPrepareUnmount'

    def onUnmounted(self, device):
        print 'onUnmounted'

    def onMounted(self, device):
        print 'onMounted'

    def onPrepareHibernate(self):
        print 'onPrepareHibernate'

    def onChangeLocale(self, locale):
        print 'onChangeLocale'

    def onChangedOrientation(self, orientation):
        print 'onChangedOrientation'


    def do_close(self):
        self.on_quit(None)

    def do_about(self, name, version):
        dialog = gtk.Dialog("About", None,
                            gtk.DIALOG_DESTROY_WITH_PARENT,
                            (gtk.STOCK_OK, gtk.RESPONSE_OK))
        vbox = dialog.vbox

        # Application Name
        label = gtk.Label(name)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # Application Version
        ver_str = "\nVersion: %s\n" % version
        label = gtk.Label(ver_str)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # create some space in the dialog
        label = gtk.Label("                                      ")
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        vbox.show()
        dialog.set_default_response(gtk.RESPONSE_OK)
        dialog.run()
        dialog.destroy()
        
app = MyApp()
gtk.main()
