import pygtk
pygtk.require('2.0')
import gtk, gobject, glib, cairo, pango
import time

import erapp


APP_NAME = "StopWatch"
APP_VERSION = 1

class CommandArea(gtk.HBox):
    def __init__(self):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0

        # START
        self.btn_start = gtk.Button("START")
        self.btn_start.connect("clicked", lambda w: app.do_start())
        self.pack_start(self.btn_start, False, False, 0)

        # CLOSE
        self.btn_close = gtk.Button()
        self.btn_close.set_relief(gtk.RELIEF_NONE)
        image = gtk.Image()
        image.set_from_stock(gtk.STOCK_STOP, gtk.ICON_SIZE_LARGE_TOOLBAR)
        self.btn_close.set_image(image)
        self.btn_close.connect("clicked", lambda w: app.do_close())
        self.pack_end(self.btn_close, False, False, 0)


class StopArea(gtk.HBox):
    def __init__(self, count):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        self.count = count

        # STOP buttons
        self.btn_stop_list = []
        for btn in range(count):
            name = "stop %d" % (btn+1)
            widget = gtk.Button(name)
            self.btn_stop_list.append(widget)

            widget.connect("clicked", self.on_stop, btn)
            widget.set_size_request(100,100)

            self.pack_start(widget, True, True, 0)

    def on_stop(self, widget, btn=None):
        #print "Stop of %d" % btn
        app.do_stop(btn)
        

class CounterArea(gtk.HBox):
    def __init__(self, count):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        self.count = count

        self.btn_counter_list = []
        self.btn_count_list = []
        for cnt in range(count):
            widget = gtk.Entry()
            self.btn_counter_list.append(widget)
            self.btn_count_list.append(0)
            widget.set_text("0")
            widget.set_editable(False)
            self.pack_start(widget, True, True, 0)

    def increase(self, cnt):
        self.btn_count_list[cnt] += 1
        self.btn_counter_list[cnt].set_text(str(self.btn_count_list[cnt]))

    def clear_all(self):
        for cnt in range(self.count):
            self.btn_count_list[cnt] = 0
            self.btn_counter_list[cnt].set_text(str(self.btn_count_list[cnt]))
        
class DataArea(gtk.HBox):
    def __init__(self):
        gtk.HBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0

        self.buffer = gtk.TextBuffer()

        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

        self.text_view = gtk.TextView(self.buffer)
        self.text_view.set_wrap_mode(gtk.WRAP_WORD)

        self.pack_start(sw, True, True, 0)
        sw.add(self.text_view)

        self.text_view.grab_focus()

    def InsertText(self, txt):
        iter = self.buffer.get_iter_at_offset(0)
        self.buffer.insert(iter, txt)
        
def on_send_startup_complete():
    try:
        win = app.window.xid
    except:
        # in simulator on x86 this does not work, so use substitue
        win = 1
    app.ipc.send_startup_complete(win)
    return False

class AppWindow(gtk.VBox):
    def __init__(self):
        gtk.VBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0
        # size request needed for desktop
        self.set_size_request(700, 900)
        self.nr_item = 4

        # Command Area
        self.command_area = CommandArea()
        self.pack_start(self.command_area, False, False, 0)

        # Stop Area
        self.stop_area = StopArea(self.nr_item)
        self.pack_start(self.stop_area, False, False, 0)

        # Counter Area
        self.counter_area = CounterArea(self.nr_item)
        self.pack_start(self.counter_area, False, False, 0)

        # Data Area
        self.data_area = DataArea()
        self.pack_start(self.data_area, True, True, 0)

class MyApp(erapp.DrApplication, gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self)
        self.build_ui()
        self.build_dr()
        glib.idle_add(on_send_startup_complete)
        self.do_start() # temp call

    def build_ui(self):
        self.set_title("StopWatch")
        self.connect("destroy", self.on_quit)
        self.connect("key-press-event", self.do_key_pressed_event)
        self.connect("key-release-event", self.do_key_released_event)
        # draw 'hello world'
        self.app_win = AppWindow()
        self.add(self.app_win)
        self.show_all()

    def on_quit(self, widget):
        print "Quiting"
        gtk.main_quit()
        pass

    def do_key_pressed_event(self, widget, key):
        #print gtk.gdk.keyval_name(key.keyval)
        return True

    def do_key_released_event(self, widget, ev):
        keyname = gtk.gdk.keyval_name(ev.keyval)
        #print "Key-up: %d-%d%s" % (ev.state, ev.keyval, keyname)
        if ev.state == gtk.gdk.SHIFT_MASK:
            pass
        if keyname == 'Left':
            print "Left"
        elif keyname == 'Right':
            print "Right"
        elif keyname == 'Up':
            print "Up"
        elif keyname == 'Down':
            print "Down"
        elif keyname == 'Page_Up':
            print "Page_Up"
        elif keyname == 'Page_Down':
            print "Page_Down"
        elif keyname == 'Home':
            print "Home"
        elif keyname == 'End':
            print "End"
        elif keyname == 'BackSpace':
            print "BackSpace"
        return True

    def build_dr(self):
        # For the name no spaces are allowed, only use lower case characters
        self.ipc = erapp.DrIpc("stopwatch", "1.0", self);
        menu_manager = erapp.MenuManager(self.ipc);
        self.menu_manager = menu_manager
        # menu
        menu_main = erapp.Menu(menu_manager, "menumain", "StopWatch");
        self.menu_main = menu_main
        group_main = menu_main.addGroup("groupmain", "Main Buttons");

        group_main.addItem("close",       "Close",        "close");
        group_main.addItem("about",       "About",        "info");
        menu_main.realise();

        # toolbar
        menu_manager.add_toolbar_item("stopwatch_menumain", "stopwatch_groupmain",  "close");
        menu_manager.add_toolbar_item("stopwatch_menumain", "stopwatch_groupmain",  "about");
        
        menu_main.show();

    def onMenuClick(self, item, group, menu, state):
        print 'onMenuClick'
        # group in concatenation of ipc-name and group-name
        if group == "stopwatch_groupmain":
            if item == "close":
                self.do_close()
            elif item == "about":
                self.do_about(APP_NAME, APP_VERSION)

    def onFileOpen(self, filename):
        print 'onFileOpen'

    def onFileClose(self, filename):
        print 'onFileClose'

    def onWindowChange(self, xid, activated):
        print 'onWindowChange'
        if activated:
            self.menu_main.show()

    def onPrepareUnmount(self, device):
        print 'onPrepareUnmount'

    def onUnmounted(self, device):
        print 'onUnmounted'

    def onMounted(self, device):
        print 'onMounted'

    def onPrepareHibernate(self):
        print 'onPrepareHibernate'

    def onChangeLocale(self, locale):
        print 'onChangeLocale'

    def onChangedOrientation(self, orientation):
        print 'onChangedOrientation'


    def do_close(self):
        self.on_quit(None)

    def do_stop(self, btn):
        stop_time = time.time()
        deltatime = stop_time - self.start_time
        time_str = str(deltatime)
        txt =  "Stop of %d at %s\n" % (btn, time_str)
        self.app_win.counter_area.increase(btn)
        self.app_win.data_area.InsertText(txt)

    def do_start(self):
        self.start_time = time.time()
        self.app_win.data_area.InsertText("Timer (re)started\n")
        self.app_win.counter_area.clear_all()
        
    def do_about(self, name, version):
        dialog = gtk.Dialog("About", None,
                            gtk.DIALOG_DESTROY_WITH_PARENT,
                            (gtk.STOCK_OK, gtk.RESPONSE_OK))
        vbox = dialog.vbox

        # Application Name
        label = gtk.Label(name)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # Application Version
        ver_str = "\nVersion %d\n" % version
        label = gtk.Label(ver_str)
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        # create some space in the dialog
        label = gtk.Label("                                      ")
        label.show()
        vbox.pack_start(label, False, False, 3)
        label.set_justify(gtk.JUSTIFY_CENTER)

        vbox.show()
        dialog.set_default_response(gtk.RESPONSE_OK)
        dialog.run()
        dialog.destroy()
        
app = MyApp()
gtk.main()
