#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Dennis Cranston <dennis_cranston@yahoo.com>'
__docformat__ = 'restructuredtext en'

import random, traceback

'''
Estimates the total number of locations.  
The algorithm is based on m0ngr31's script
at http://www.joeipson.com/kindleSide.zip.
'''
def estimate_locations(format, book_path):
    try:
        fp = open(book_path, "r+b")
        fp.seek(80)
        data = fp.read(2)
        fp.seek(int(data.encode('hex_codec'), 16) + 4)
        data = fp.read(4)
        fp.close()
        return (int(data.encode('hex_codec'), 16) / 150) + 1
    except:
        traceback.print_exc()
        return None
        
'''
Generates a random ASIN string.  
The algorithm is based on m0ngr31's script 
at http://www.joeipson.com/kindleSide.zip.
'''
def generate_asin(format, book_path):
    return "B00" \
     + str(random.randrange(0, 10000)).zfill(4) \
     + str(random.randrange(0, 10000)).zfill(4)
