#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Dennis Cranston <dennis_cranston@yahoo.com>'
__docformat__ = 'restructuredtext en'

import os, traceback
from PyQt4.Qt import QProgressDialog, QString, QTimer
from calibre.gui2 import warning_dialog

class QueueProgressDialog(QProgressDialog):

    def __init__(self, gui, book_ids, tdir, locations_col,
                 asin_col, queue, db):
        QProgressDialog.__init__(self, '', QString(), 0, len(book_ids), gui)
        self.setWindowTitle('Queueing Books For WebOS Kindle-Import Plugin')
        self.setMinimumWidth(500)
        self.book_ids, self.tdir, self.queue, self.db = \
          book_ids, tdir, queue, db
        self.locations_custom_column = locations_col
        self.asin_custom_column = asin_col
        self.gui = gui
        self.i, self.bad, self.books_to_scan = 0, [], []
        QTimer.singleShot(0, self.do_book)
        self.exec_()

    def do_book(self):
        book_id = self.book_ids[self.i]
        self.i += 1

        try:
            title = self.db.title(book_id, index_is_id=True)
            found_format = False
            for format in ['MOBI']:
                if self.db.has_format(book_id, format, index_is_id=True):
                    try:
                        self.setLabelText(_('Queueing ')+title)
                        # Copy the book to the temp directory, using book id as filename
                        dest_file = os.path.join(self.tdir, '%d.%s'%(book_id, format.lower()))
                        with open(dest_file, 'w+b') as f:
                            self.db.copy_format_to(book_id, format, f, index_is_id=True)
                        self.books_to_scan.append((book_id, title, format, dest_file))
                        found_format = True
                    except:
                        self.bad.append(book_id)
                    break
            if not found_format:
                self.bad.append(book_id)
        except:
            traceback.print_exc()
            self.bad.append(book_id)

        self.setValue(self.i)
        if self.i >= len(self.book_ids):
            return self.do_queue()
        else:
            QTimer.singleShot(0, self.do_book)

    def do_queue(self):
        self.hide()
        if self.bad != []:
            res = []
            for id in self.bad:
                title = self.db.title(id, True)
                res.append('%s'%title)
            msg = '%s' % '\n'.join(res)
            warning_dialog(self.gui, _('WebOS Kindle-Import Plugin'),
                _('Could not read %d of %d books, because no <b>MOBI</b> '
                'source format was found.  You need to convert your book(s) '
                'to the <b>MOBI</b> format first.') % (len(res), len(self.book_ids)),
                msg).exec_()
        self.gui = None
        # Queue a job to process these Mobi books
        self.queue(self.tdir, self.books_to_scan, self.locations_custom_column,
                   self.asin_custom_column)
