/*
 * Decompiled with CFR 0.152.
 */
package jts.kindle.kco;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import jts.kindle.clippings.types.Book;
import jts.kindle.clippings.types.Clipping;
import jts.kindle.clippings.utils.CalendarUtils;
import jts.kindle.clippings.utils.Debug;
import jts.kindle.clippings.utils.FileUtils;
import jts.kindle.clippings.utils.ParserUtils;
import jts.kindle.kco.CopyToClipboardActionListener;
import jts.kindle.kco.RemoveClippingActionListener;

public class Main
extends JFrame
implements ActionListener,
WindowListener {
    String aboutText = "Clippings Organiser\n\nDeveloped by Antony Jordan\nwww.wiccan-two.co.cc\n\nThanks to PoP, thomass and everyone\nat www.mobileread.com for thier help\nin debugging.";
    private JComboBox<Book> booksComboBox;
    private static JFileChooser fc;
    private static final FileNameExtensionFilter kcoFileFilter;
    private static final FileNameExtensionFilter txtFileFilter;
    private static final FileNameExtensionFilter xmlFileFilter;
    private static final FileNameExtensionFilter htmlFileFilter;
    private JPanel mainPanel;
    private JPanel clippingsPanel;
    private JMenuItem saveMenuItem;
    private JMenu exportXMLMenu;
    private JMenu exportHTMLMenu;
    private ArrayList<Book> books = new ArrayList();
    private static final int HIGHLIGHTS = 0;
    private static final int NOTES = 1;
    private static final int BOOKMARKS = 2;
    JLabel statusLabel;
    int currentBook = 0;

    static {
        kcoFileFilter = new FileNameExtensionFilter("Kindle Clippings Organizer Files", "kco");
        txtFileFilter = new FileNameExtensionFilter("Text Files", "txt", "TXT", "Txt");
        xmlFileFilter = new FileNameExtensionFilter("XML Files", "xml", "Xml", "XML");
        htmlFileFilter = new FileNameExtensionFilter("HTML Files", "html", "Html", "HTML");
    }

    public Main() {
        Debug.setGUIEnabled(true);
        this.setDefaultCloseOperation(0);
        this.setUpMainWindow();
        this.setUpMenu();
        this.setUpStatusBar();
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.setVisible(true);
    }

    private void setUpClippingsPanel(Book book) {
        this.invalidate();
        this.mainPanel.remove(this.clippingsPanel);
        this.clippingsPanel = new JPanel();
        this.clippingsPanel.setLayout(new BorderLayout());
        JLabel authorLabel = new JLabel("Author: " + book.getAuthor());
        authorLabel.setAlignmentX(0.0f);
        JTabbedPane tabs = new JTabbedPane();
        JScrollPane notesScrollPane = new JScrollPane(this.generateClippingsPanel(book, 1));
        JScrollPane highlightsScrollPane = new JScrollPane(this.generateClippingsPanel(book, 0));
        JScrollPane bookmarksScrollPane = new JScrollPane(this.generateClippingsPanel(book, 2));
        tabs.add("Notes", notesScrollPane);
        tabs.add("Highlights", highlightsScrollPane);
        tabs.add("Bookmarks", bookmarksScrollPane);
        this.clippingsPanel.add((Component)authorLabel, "North");
        this.clippingsPanel.add((Component)tabs, "Center");
        this.mainPanel.add((Component)this.clippingsPanel, "Center");
        this.validate();
    }

    private void setUpMainWindow() {
        this.invalidate();
        this.setTitle("Clippings Organizer");
        this.setBounds(0, 0, 500, 500);
        this.setMaximumSize(new Dimension(250, 250));
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.booksComboBox = new JComboBox();
        this.booksComboBox.addActionListener(this);
        this.booksComboBox.setActionCommand("BOOK_SELECTED");
        this.clippingsPanel = new JPanel();
        this.mainPanel.add(this.clippingsPanel);
        this.mainPanel.add(this.booksComboBox, "North");
        this.add((Component)this.mainPanel, "Center");
        this.validate();
        this.addWindowListener(this);
    }

    private void setUpMenu() {
        JMenuItem openMenuItem = new JMenuItem("Open");
        this.saveMenuItem = new JMenuItem("Save");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        JMenuItem importMenuItem = new JMenuItem("Import");
        this.exportXMLMenu = new JMenu("Export as XML");
        this.exportHTMLMenu = new JMenu("Export as HTML");
        JMenuItem exportBookXmlMenuItem = new JMenuItem("Current Book");
        JMenuItem exportBooksXmlMenuItem = new JMenuItem("All Books");
        JMenuItem exportBookHtmlMenuItem = new JMenuItem("Current Book");
        JMenuItem exportBooksHtmlMenuItem = new JMenuItem("All Books");
        this.exportXMLMenu.add(exportBookXmlMenuItem);
        this.exportXMLMenu.add(exportBooksXmlMenuItem);
        this.exportHTMLMenu.add(exportBookHtmlMenuItem);
        this.exportHTMLMenu.add(exportBooksHtmlMenuItem);
        JMenuItem aboutMenuItem = new JMenuItem("About");
        JMenuItem helpMenuItem = new JMenuItem("Help");
        openMenuItem.setActionCommand("OPEN");
        this.saveMenuItem.setActionCommand("SAVE");
        exitMenuItem.setActionCommand("EXIT");
        importMenuItem.setActionCommand("IMPORT");
        exportBookXmlMenuItem.setActionCommand("EXPORT_XML_BOOK");
        exportBooksXmlMenuItem.setActionCommand("EXPORT_XML_BOOKS");
        exportBookHtmlMenuItem.setActionCommand("EXPORT_HTML_BOOK");
        exportBooksHtmlMenuItem.setActionCommand("EXPORT_HTML_BOOKS");
        aboutMenuItem.setActionCommand("ABOUT");
        helpMenuItem.setActionCommand("HELP");
        openMenuItem.addActionListener(this);
        this.saveMenuItem.addActionListener(this);
        exitMenuItem.addActionListener(this);
        importMenuItem.addActionListener(this);
        exportBookXmlMenuItem.addActionListener(this);
        exportBooksXmlMenuItem.addActionListener(this);
        exportBookHtmlMenuItem.addActionListener(this);
        exportBooksHtmlMenuItem.addActionListener(this);
        aboutMenuItem.addActionListener(this);
        helpMenuItem.addActionListener(this);
        JMenu fileMenu = new JMenu("File");
        JMenu importExportMenu = new JMenu("Import/Export");
        JMenu helpMenu = new JMenu("Help");
        fileMenu.add(openMenuItem);
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(exitMenuItem);
        importExportMenu.add(importMenuItem);
        importExportMenu.addSeparator();
        importExportMenu.add(this.exportXMLMenu);
        importExportMenu.add(this.exportHTMLMenu);
        helpMenu.add(aboutMenuItem);
        helpMenu.add(helpMenuItem);
        JMenuBar menu = new JMenuBar();
        menu.add(fileMenu);
        menu.add(importExportMenu);
        menu.add(helpMenu);
        this.disableSaveMenuItems();
        this.add((Component)menu, "North");
    }

    private void setUpStatusBar() {
        JPanel statusBarPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("");
        statusBarPanel.add((Component)this.statusLabel, "West");
        this.mainPanel.add((Component)statusBarPanel, "South");
    }

    private void notImplemented() {
        JOptionPane.showMessageDialog(this, "Not yet implemented");
    }

    private void disableSaveMenuItems() {
        this.saveMenuItem.setEnabled(false);
        this.exportXMLMenu.setEnabled(false);
        this.exportHTMLMenu.setEnabled(false);
    }

    private void enableSaveMenuItems() {
        this.saveMenuItem.setEnabled(true);
        this.exportXMLMenu.setEnabled(true);
        this.exportHTMLMenu.setEnabled(true);
    }

    private void updateBooksCombo() {
        this.invalidate();
        this.mainPanel.remove(this.booksComboBox);
        this.booksComboBox = new JComboBox();
        this.booksComboBox.addActionListener(this);
        this.booksComboBox.setActionCommand("BOOK_SELECTED");
        for (Book book : this.books) {
            this.booksComboBox.addItem(book);
        }
        this.mainPanel.add(this.booksComboBox, "North");
        this.validate();
    }

    private static void resetFileChooser() {
        fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "The selected file already exists, would you like to overwrite it?", "Existing file", 1);
                    Debug.debug("Main", "resetFileChooser-approveSelection", "result", Integer.toString(result));
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            break;
                        }
                        case 2: {
                            this.cancelSelection();
                        }
                    }
                } else {
                    super.approveSelection();
                }
            }
        };
    }

    private JPanel generateClippingsPanel(Book book, int type) {
        ArrayList<Clipping> clippings;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        switch (type) {
            case 0: {
                clippings = book.getHighlights();
                break;
            }
            case 1: {
                clippings = book.getNotes();
                break;
            }
            case 2: {
                clippings = book.getBookmarks();
                break;
            }
            default: {
                clippings = book.getClippings();
            }
        }
        for (Clipping clipping : clippings) {
            panel.add(this.generateClippingDisplayPanel(book, clipping));
        }
        return panel;
    }

    private JPanel generateClippingDisplayPanel(Book book, Clipping clipping) {
        book.sortClippings();
        JPanel textPanel = new JPanel(new BorderLayout()){

            @Override
            public void scrollRectToVisible(Rectangle r) {
            }
        };
        JTextArea text = new JTextArea(clipping.getText());
        JLabel date = new JLabel("Date: " + CalendarUtils.calendarToDateString(clipping.getDate()));
        JLabel time = new JLabel("Time: " + CalendarUtils.calendarToTimeString(clipping.getDate()));
        JLabel pageLabel = new JLabel("Page: " + Integer.toString(clipping.getPage()));
        JLabel startLocationLabel = new JLabel("Start location: " + Integer.toString(clipping.getStartEnd()[0]));
        JLabel endLocationLabel = new JLabel("End location: " + Integer.toString(clipping.getStartEnd()[1]));
        JMenuItem xmlButton = new JMenuItem("Get XML");
        JMenuItem htmlButton = new JMenuItem("Get HTML");
        JMenuItem textButton = new JMenuItem("Get Text");
        JMenuItem removeButton = new JMenuItem("Remove");
        textPanel.setAlignmentX(0.0f);
        text.setAlignmentX(0.0f);
        date.setAlignmentX(0.0f);
        time.setAlignmentX(0.0f);
        pageLabel.setAlignmentX(0.0f);
        startLocationLabel.setAlignmentX(0.0f);
        endLocationLabel.setAlignmentX(0.0f);
        xmlButton.setAlignmentX(0.5f);
        htmlButton.setAlignmentX(0.5f);
        textButton.setAlignmentX(0.5f);
        removeButton.setAlignmentX(0.5f);
        xmlButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        htmlButton.setBorder(BorderFactory.createLineBorder(Color.black));
        textButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        removeButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        xmlButton.addActionListener(new CopyToClipboardActionListener(this, clipping.toXML(0)));
        htmlButton.addActionListener(new CopyToClipboardActionListener(this, clipping.toHTML()));
        textButton.addActionListener(new CopyToClipboardActionListener(this, clipping.getText()));
        removeButton.addActionListener(new RemoveClippingActionListener(this, clipping, book));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setMinimumSize(new Dimension(100, 20));
        text.setEditable(false);
        text.setCaretPosition(0);
        textPanel.add((Component)text, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setAlignmentX(0.0f);
        if (!clipping.getText().equals("")) {
            JLabel textLabel = new JLabel("Text: ");
            textLabel.setAlignmentX(0.0f);
            panel.add(textLabel);
            panel.add(textPanel);
        }
        panel.add(date);
        panel.add(time);
        if (clipping.getPage() > 0) {
            panel.add(pageLabel);
        }
        if (clipping.getStartEnd()[0] > 0 && clipping.getStartEnd()[1] > 0) {
            panel.add(startLocationLabel);
            panel.add(endLocationLabel);
        }
        JMenuBar bar = new JMenuBar();
        bar.add(xmlButton);
        bar.add(htmlButton);
        if (!clipping.getText().equals("")) {
            bar.add(textButton);
        }
        bar.add(removeButton);
        bar.setAlignmentX(0.0f);
        panel.add(bar);
        return panel;
    }

    private void openKCO() {
        this.invalidate();
        this.updateStatusText("Opening file...");
        this.books = new ArrayList();
        Main.resetFileChooser();
        fc.setFileFilter(kcoFileFilter);
        int ret = fc.showOpenDialog(this);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                fis = new FileInputStream(file);
                in = new ObjectInputStream(fis);
                try {
                    Object objBooks = in.readObject();
                    this.books = (ArrayList)objBooks;
                    this.updateBooksCombo();
                    this.setUpClippingsPanel(this.books.get(0));
                    this.enableSaveMenuItems();
                }
                catch (ClassNotFoundException e1) {
                    Debug.error("Unable to open file");
                }
                in.close();
            }
            catch (IOException ex) {
                Debug.error("Unable to open file");
            }
        }
        this.updateStatusText("");
        this.validate();
    }

    private void saveKCO() {
        new Thread(){

            @Override
            public void run() {
                fc.setFileFilter(kcoFileFilter);
                int ret = fc.showSaveDialog(Main.this);
                if (ret == 0) {
                    File file = fc.getSelectedFile();
                    String filePath = file.getAbsolutePath();
                    if (!filePath.endsWith(".kco")) {
                        file = new File(String.valueOf(filePath) + ".kco");
                    }
                    FileOutputStream fos = null;
                    ObjectOutputStream out = null;
                    try {
                        fos = new FileOutputStream(file);
                        out = new ObjectOutputStream(fos);
                        out.writeObject(Main.this.books);
                        out.close();
                    }
                    catch (IOException ex) {
                        Debug.error("Unable to save file.");
                    }
                }
            }
        }.start();
    }

    private void importClippings() {
        this.invalidate();
        this.updateStatusText("Importing clippings...");
        Main.resetFileChooser();
        Debug.debug("Main", "importClippings", "File chooser reset");
        fc.setFileFilter(txtFileFilter);
        Debug.debug("Main", "importClippings", "File chooser filter set");
        Debug.debug("Main", "importClippings", "Showing file chooser");
        int ret = fc.showOpenDialog(this);
        Debug.debug("Main", "importClippings", "File choser closed");
        if (ret == 0) {
            File file = fc.getSelectedFile();
            this.books = ParserUtils.parseBooks(this.books, FileUtils.fileToString(file));
            this.updateBooksCombo();
            this.setUpClippingsPanel(this.books.get(0));
            this.enableSaveMenuItems();
        }
        this.updateStatusText("");
        this.validate();
    }

    private void exportXMLBook() {
        this.updateStatusText("Exporting current book as XML...");
        Main.resetFileChooser();
        fc.setFileFilter(xmlFileFilter);
        int ret = fc.showSaveDialog(this);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (!filePath.endsWith(".xml")) {
                file = new File(String.valueOf(filePath) + ".xml");
            }
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                fw = new FileWriter(file);
                out = new BufferedWriter(fw);
                out.write(this.books.get(this.currentBook).toXML(0));
                out.close();
            }
            catch (IOException ex) {
                Debug.error("Unable to save file.");
            }
        }
        this.updateStatusText("");
    }

    private void exportXMLBooks() {
        this.updateStatusText("Exporting all books as XML...");
        Main.resetFileChooser();
        fc.setFileFilter(xmlFileFilter);
        int ret = fc.showSaveDialog(this);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (!filePath.endsWith(".xml")) {
                file = new File(String.valueOf(filePath) + ".xml");
            }
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                fw = new FileWriter(file);
                out = new BufferedWriter(fw);
                out.write(Book.booksToXML(this.books));
                out.close();
            }
            catch (IOException ex) {
                Debug.error("Unable to save file.");
            }
        }
        this.updateStatusText("");
    }

    private void exportHTMLBook() {
        this.updateStatusText("Exporting current book as HTML...");
        Main.resetFileChooser();
        fc.setFileFilter(xmlFileFilter);
        int ret = fc.showSaveDialog(this);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (!filePath.endsWith(".html")) {
                file = new File(String.valueOf(filePath) + ".html");
            }
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                fw = new FileWriter(file);
                out = new BufferedWriter(fw);
                out.write(this.books.get(this.currentBook).toHTML());
                out.close();
            }
            catch (IOException ex) {
                Debug.error("Unable to save file.");
            }
        }
        this.updateStatusText("");
    }

    private void exportHTMLBooks() {
        this.updateStatusText("Exporting all books as HTML...");
        Main.resetFileChooser();
        fc.setFileFilter(htmlFileFilter);
        int ret = fc.showSaveDialog(this);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            String filePath = file.getAbsolutePath();
            if (!filePath.endsWith(".html")) {
                file = new File(String.valueOf(filePath) + ".html");
            }
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                fw = new FileWriter(file);
                out = new BufferedWriter(fw);
                out.write(Book.booksToHTML(this.books));
                out.close();
            }
            catch (IOException ex) {
                Debug.error("Unable to save file.");
            }
        }
        this.updateStatusText("");
    }

    public void updateStatusText(String text) {
        this.invalidate();
        this.statusLabel.setText(text);
        this.validate();
    }

    private void bookSelected() {
        this.currentBook = this.booksComboBox.getSelectedIndex();
        this.setUpClippingsPanel((Book)this.booksComboBox.getSelectedObjects()[0]);
    }

    public void resetClippingsPanel() {
        this.invalidate();
        this.updateBooksCombo();
        this.setUpClippingsPanel(this.books.get(0));
        this.validate();
    }

    public void close() {
        int choice = JOptionPane.showConfirmDialog(this, "Would you like to save before exiting?", "Exiting...", 1);
        switch (choice) {
            case 0: {
                this.saveKCO();
                System.exit(0);
                break;
            }
            case 1: {
                System.exit(0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("EXIT")) {
            this.close();
        } else if (e.getActionCommand().equals("IMPORT")) {
            this.importClippings();
        } else if (e.getActionCommand().equals("OPEN")) {
            this.openKCO();
        } else if (e.getActionCommand().equals("SAVE")) {
            this.saveKCO();
        } else if (e.getActionCommand().equals("BOOK_SELECTED")) {
            this.bookSelected();
        } else if (e.getActionCommand().equals("EXPORT_XML_BOOK")) {
            this.exportXMLBook();
        } else if (e.getActionCommand().equals("EXPORT_XML_BOOKS")) {
            this.exportXMLBooks();
        } else if (e.getActionCommand().equals("EXPORT_HTML_BOOK")) {
            this.exportHTMLBook();
        } else if (e.getActionCommand().equals("EXPORT_HTML_BOOKS")) {
            this.exportHTMLBooks();
        } else if (e.getActionCommand().equals("ABOUT")) {
            JOptionPane.showMessageDialog(this, this.aboutText, "About", 1);
        } else if (e.getActionCommand().equals("HELP")) {
            this.notImplemented();
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.close();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

