/*
 * Decompiled with CFR 0.152.
 */
package jts.kindle.clippings.utils;

import java.util.ArrayList;
import java.util.Calendar;
import jts.kindle.clippings.types.Book;
import jts.kindle.clippings.types.Clipping;
import jts.kindle.clippings.utils.CalendarUtils;
import jts.kindle.clippings.utils.Debug;

public class ParserUtils {
    public static String parseAuthor(String input) {
        String temp = input.substring(0, input.indexOf("\n"));
        String author = "";
        Debug.debug("Clipping", "parseAuthor", "temp", temp);
        if (temp.contains("(") && temp.contains(")")) {
            Integer authorStartIndex = temp.lastIndexOf("(");
            Debug.debug("Clipping", "parseAuthor", "authorStartIndex", authorStartIndex.toString());
            authorStartIndex = authorStartIndex + 1;
            Debug.debug("Clipping", "parseAuthor", "authorStartIndex", authorStartIndex.toString());
            Integer authorEndIndex = temp.lastIndexOf(")");
            Debug.debug("Clipping", "parseAuthor", "authorEndIndex", authorEndIndex.toString());
            author = new String(temp.substring(authorStartIndex, authorEndIndex));
            author = author.trim();
        } else {
            author = "UNKNOWN";
        }
        return author;
    }

    public static String parseTitle(String input) {
        String temp = new String(input.substring(0, input.indexOf("\n")));
        int authorStartIndex = temp.lastIndexOf("(");
        String title = "";
        title = authorStartIndex > -1 ? new String(temp.substring(0, authorStartIndex)) : temp;
        title = title.trim();
        return title;
    }

    public static int[] parseStartEnd(String input) {
        Debug.debug(1, "Clipping", "parseStartEnd", "input", input);
        int[] retVal = new int[2];
        String startEnd = "0";
        if (input.contains("Loc.")) {
            startEnd = new String(input.substring(input.indexOf("Loc.") + 5));
            Debug.debug(2, "Clipping", "parseStartEnd", "startEnd", startEnd);
            startEnd = new String(startEnd.substring(0, startEnd.indexOf("|")));
            Debug.debug(3, "Clipping", "parseStartEnd", "startEnd", startEnd);
        }
        if (input.contains("Location")) {
            startEnd = new String(input.substring(input.indexOf("Location") + 9));
            Debug.debug(2, "Clipping", "parseStartEnd", "startEnd", startEnd);
            startEnd = new String(startEnd.substring(0, startEnd.indexOf("|")));
            Debug.debug(3, "Clipping", "parseStartEnd", "startEnd", startEnd);
        }
        if ((startEnd = startEnd.trim()).contains("-")) {
            String[] temp = startEnd.split("-");
            temp[0] = temp[0].trim();
            temp[1] = temp[1].trim();
            retVal[0] = Integer.parseInt(temp[0]);
            retVal[1] = Integer.parseInt(temp[1]);
        } else {
            int tmp156_153;
            retVal[1] = tmp156_153 = Integer.parseInt(startEnd);
            retVal[0] = tmp156_153;
        }
        return retVal;
    }

    public static int parsePage(String input) {
        Debug.debug("Clipping", "parseStartEnd", "input", input);
        int retVal = 0;
        String page = new String(input.substring(input.indexOf("\n") + 3, input.indexOf(" | ")));
        Debug.debug("Clipping", "parsePage", "page", page);
        page = page.contains("Loc.") || page.contains("Location") ? "0" : new String(page.substring(page.indexOf("Page") + 5));
        Debug.debug("Clipping", "parsePage", "page", page);
        page = page.trim();
        retVal = Integer.parseInt(page);
        return retVal;
    }

    public static String parseType(String input) {
        String type = new String(input.substring(input.indexOf("\n") + 3, input.lastIndexOf(" | ")));
        if (type.contains("Loc.")) {
            type = new String(type.substring(0, type.indexOf(" Loc. ")));
        }
        if (type.contains("Location")) {
            type = new String(type.substring(5, type.indexOf(" Location ")));
        }
        if (type.contains("Page") && (type = new String(type.substring(0, type.indexOf("Page")))).contains("on")) {
            type = type.replace("on", "");
        }
        type = type.trim();
        Debug.debug("ParserUtils", "parseType", "type", type);
        return type;
    }

    public static Calendar parseDateTime(String input) {
        String date = new String(input.substring(input.indexOf("|")));
        if (date.contains("\n")) {
            date = date.substring(0, date.indexOf("\n"));
        }
        date = date.replace("| Added on ", "");
        Calendar calendar = Calendar.getInstance();
        String strMonth = new String(date.substring(date.indexOf(", ")));
        date = new String(strMonth.substring(strMonth.indexOf(" ")));
        strMonth = strMonth.replace(", ", "#");
        date = new String(strMonth.substring(strMonth.indexOf(" ")));
        strMonth = new String(strMonth.substring(0, strMonth.indexOf(" ")));
        strMonth = new String(strMonth.substring(1));
        String[] dayYearTime = date.split("#");
        dayYearTime[0] = dayYearTime[0].trim();
        dayYearTime[1] = dayYearTime[1].trim();
        dayYearTime[2] = dayYearTime[2].trim();
        int month = CalendarUtils.monthToInt(strMonth);
        int day = Integer.parseInt(dayYearTime[0]);
        int year = Integer.parseInt(dayYearTime[1]);
        int[] time = CalendarUtils.timeToInt(dayYearTime[2]);
        calendar.set(year, --month, day, time[0], time[1]);
        return calendar;
    }

    public static String parseText(String input) {
        input = String.valueOf(input) + "\n";
        Debug.debug("Clipping", "parseText", "input", input);
        String text = "";
        Debug.debug("Clipping", "parseText", "input.lastIndexOf(\"\\n\")", Integer.toString(input.lastIndexOf("\n")));
        Debug.debug("Clipping", "parseText", "input.length()", Integer.toString(input.length()));
        text = new String(input.substring(input.indexOf("\n", input.indexOf("\n") + 1)));
        text = text.trim();
        Debug.debug("Clipping", "parseText", "text", text);
        return text;
    }

    public static Clipping parseClipping(String input) {
        Clipping retVal = new Clipping();
        retVal.setAuthor(ParserUtils.parseAuthor(input));
        retVal.setTitle(ParserUtils.parseTitle(input));
        retVal.setStartEnd(ParserUtils.parseStartEnd(input));
        retVal.setType(ParserUtils.parseType(input));
        retVal.setDate(Calendar.getInstance());
        retVal.setDate(ParserUtils.parseDateTime(input));
        retVal.setText(ParserUtils.parseText(input));
        retVal.setPage(ParserUtils.parsePage(input));
        return retVal;
    }

    public static Clipping[] parseClippings(String input) {
        String[] clippings;
        ArrayList<Clipping> retVal = new ArrayList<Clipping>();
        String delimiter = "==========";
        input = input.substring(0, input.lastIndexOf(delimiter));
        String[] stringArray = clippings = input.split(delimiter);
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            String clipping = stringArray[n2];
            Clipping clip = new Clipping(clipping.trim());
            retVal.add(clip);
            ++n2;
        }
        return retVal.toArray(new Clipping[retVal.size()]);
    }

    public static ArrayList<Book> parseBooks(ArrayList<Book> books, String input) {
        Clipping[] clippings;
        Clipping[] clippingArray = clippings = ParserUtils.parseClippings(input);
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            Clipping clipping = clippingArray[n2];
            String clippingTitle = clipping.getTitle();
            String clippingAuthor = clipping.getAuthor();
            boolean added = false;
            for (Book book : books) {
                if (!clippingTitle.equals(book.getTitle()) || !clippingAuthor.equals(book.getAuthor())) continue;
                book.add(clipping, true);
                added = true;
            }
            if (!added) {
                Book book;
                book = new Book(clippingTitle, clippingAuthor);
                book.add(clipping);
                books.add(book);
            }
            ++n2;
        }
        return books;
    }
}

