/*
 * Decompiled with CFR 0.152.
 */
package jts.kindle.clippings.types;

import java.io.Serializable;
import java.util.Calendar;
import jts.kindle.clippings.utils.CalendarUtils;
import jts.kindle.clippings.utils.Debug;
import jts.kindle.clippings.utils.ParserUtils;

public class Clipping
implements Serializable,
Comparable<Clipping> {
    private static final long serialVersionUID = -1988453502727750868L;
    private String author;
    private String title;
    private int[] startEnd;
    private int page;
    private String type;
    private Calendar date;
    private String text;

    public Clipping() {
        this.author = null;
        this.title = null;
        this.startEnd = null;
        this.type = null;
        this.date = Calendar.getInstance();
        this.text = null;
        this.page = 0;
    }

    public Clipping(Clipping input) {
        this.setThis(input);
    }

    public Clipping(String input) {
        this.setThis(ParserUtils.parseClipping(input));
    }

    private void setThis(Clipping that) {
        this.setAuthor(that.getAuthor());
        this.setDate(that.getDate());
        this.setPage(that.getPage());
        this.setStartEnd(that.getStartEnd());
        this.setText(that.getText());
        this.setTitle(that.getTitle());
        this.setType(that.getType());
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public int[] getStartEnd() {
        return this.startEnd;
    }

    public String getType() {
        return this.type;
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getText() {
        return this.text;
    }

    public int getPage() {
        return this.page;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStartEnd(int[] startEnd) {
        this.startEnd = startEnd;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String toHTML() {
        String html = "";
        html = String.valueOf(html) + "\n<div class=\"clipping\">";
        html = String.valueOf(html) + "\nType: " + this.type + "<br/>";
        html = String.valueOf(html) + "\nStart location: " + this.startEnd[0] + "<br/>";
        html = String.valueOf(html) + "\nEnd location: " + this.startEnd[1] + "<br/>";
        html = String.valueOf(html) + "\nPage: " + this.page + "<br/>";
        html = String.valueOf(html) + "\nDate: " + CalendarUtils.calendarToDateString(this.date) + "<br/>";
        html = String.valueOf(html) + "\nTime: " + CalendarUtils.calendarToTimeString(this.date) + "<br/>";
        html = String.valueOf(html) + "\nText: " + this.text + "<bt/>";
        html = String.valueOf(html) + "\n<hr/>";
        html = String.valueOf(html) + "\n</div>";
        return html;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<" + this.type + ">";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Start>" + this.startEnd[0] + "</Start>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<End>" + this.startEnd[1] + "</End>";
        if (this.page > 0) {
            xml = String.valueOf(xml) + "\n\t" + indent + "<Page>" + this.page + "</Page>";
        }
        if (this.startEnd[0] > 0 && this.startEnd[1] > 0) {
            xml = String.valueOf(xml) + "\n\t" + indent + "<Date>" + CalendarUtils.calendarToDateString(this.date) + "</Date>";
            xml = String.valueOf(xml) + "\n\t" + indent + "<Time>" + CalendarUtils.calendarToTimeString(this.date) + "</Time>";
        }
        xml = String.valueOf(xml) + "\n\t" + indent + "<Text>" + this.text + "</Text>";
        xml = String.valueOf(xml) + "\n" + indent + "</" + this.type + ">";
        return xml;
    }

    public String toString() {
        String retval = "Clipping[" + this.title + ", " + this.author + ", " + this.startEnd[0] + ", " + this.startEnd[1] + ", " + this.page + ", " + this.type + ", " + this.date.toString() + ", " + this.text + "]";
        return retval;
    }

    public boolean equals(Clipping o) {
        boolean page;
        boolean text = this.getText().equals(o.getText());
        boolean type = this.getType().equals(o.getType());
        boolean start = this.getStartEnd()[0] == o.getStartEnd()[0];
        boolean end = this.getStartEnd()[1] == o.getStartEnd()[1];
        boolean author = this.getAuthor().equals(o.getAuthor());
        boolean title = this.getTitle().equals(o.getTitle());
        boolean bl = page = this.getPage() == o.getPage();
        return text && type && start && end && author && title && page;
    }

    @Override
    public int compareTo(Clipping o) {
        Debug.debug("Clipping", "compareTo", "This start", Integer.toString(this.getStartEnd()[0]));
        Debug.debug("Clipping", "compareTo", "This end", Integer.toString(this.getStartEnd()[1]));
        Debug.debug("Clipping", "compareTo", "o start", Integer.toString(o.getStartEnd()[0]));
        Debug.debug("Clipping", "compareTo", "o end", Integer.toString(o.getStartEnd()[1]));
        if (this.getStartEnd()[0] == o.getStartEnd()[0] && this.getStartEnd()[1] == o.getStartEnd()[1]) {
            Debug.debug("Clipping", "compareTo", "Equal");
            return 0;
        }
        Debug.debug("Clipping", "compareTo", "Not Equal");
        if (this.getStartEnd()[0] > o.getStartEnd()[0]) {
            Debug.debug("Clipping", "compareTo", "After");
            return 1;
        }
        Debug.debug("Clipping", "compareTo", "Before");
        return -1;
    }
}

