import pygtk
pygtk.require('2.0')
import gtk, gobject, glib, cairo, pango

import erapp


def on_send_startup_complete():
    win = app.window.xid
    app.ipc.send_startup_complete(win)
    return False

class AppWindow(gtk.VBox):
    def __init__(self):
        gtk.VBox.__init__(self)
        self.homogeneous = False
        self.spacing = 0

        hdr = gtk.Label("")
        hdr.set_markup("<b><span size='xx-large'>Hello World</span></b>")
        self.pack_start(hdr, True, True, 10)

class MyApp(erapp.DrApplication, gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self)
        self.build_ui()
        self.build_dr()
        glib.idle_add(on_send_startup_complete)

    def build_ui(self):
        self.set_title("HelloWorld")
        self.connect("destroy", self.on_quit)
        # draw 'hello world'
        self.app_win = AppWindow()
        self.add(self.app_win)
        self.show_all()

    def on_quit(self, widget):
        print "Quiting"
        gtk.main_quit()
        pass

    def build_dr(self):
        # For the name no spaces are allowed, only use lower case characters
        self.ipc = erapp.DrIpc("helloworld", "1.0", self);
        menu_manager = erapp.MenuManager(self.ipc);
        self.menu_manager = menu_manager
        # menu
        menu_main = erapp.Menu(menu_manager, "menumain", "HelloWorld");
        self.menu_main = menu_main
        group_main = menu_main.addGroup("groupmain", "Main Buttons");

        group_main.addItem("close",       "Close",        "close");
	menu_main.realise();

        # toolbar
        menu_manager.add_toolbar_item("helloworld_menumain", "helloworld_groupmain",  "close");
        
        menu_main.show();

    def onMenuClick(self, item, group, menu, state):
        print 'onMenuClick'
        # group in concatenation of ipc-name and group-name
        if group == "helloworld_groupmain":
            if item == "close":
                self.on_quit(None)

    def onFileOpen(self, filename):
        print 'onFileOpen'

    def onFileClose(self, filename):
        print 'onFileClose'

    def onWindowChange(self, xid, activated):
        print 'onWindowChange'
        if activated:
            self.menu_main.show()

    def onPrepareUnmount(self, device):
        print 'onPrepareUnmount'

    def onUnmounted(self, device):
        print 'onUnmounted'

    def onMounted(self, device):
        print 'onMounted'

    def onPrepareHibernate(self):
        print 'onPrepareHibernate'

    def onChangeLocale(self, locale):
        print 'onChangeLocale'

    def onChangedOrientation(self, orientation):
        print 'onChangedOrientation'

app = MyApp()
gtk.main()
