import csv

class Sheet(object):
    def __init__(self, name):
        # create empty dict for rows
        self.rows = {}
        self.name = name
        self.default_properties = Properties()
        self.default_properties.add_prop('name', 'default')
        # default width and height of the cells
        self.default_properties.add_prop('width', 100)
        self.default_properties.add_prop('height', 20)
        # default width and height of headers
        self.default_properties.add_prop('header-width', 40)
        self.default_properties.add_prop('header-height', 20)

    def get_cell(self, col_nr, row_nr):
        if row_nr in self.rows:
            return self.rows[row_nr].get_cell(col_nr)
        else:
            return None

    def add_cell(self, col_nr, row_nr, cell):
        if not row_nr in self.rows:
            # first create row
            self.rows[row_nr] = RowHeader()
        self.rows[row_nr].add_cell(col_nr, cell)

    def del_cell(self, col_nr, row_nr):
        if row_nr in self.rows:
            self.rows[row_nr].del_cell(col_nr)

    def get_row_properties(self):
        # only default properties allowed
        return self.default_properties
        
    def get_row_heights(self, start_y, h):
        # for now fixed size
        row_height = self.default_properties.find_property('height')
        current_y = start_y
        row_height_list = []
        while current_y < h:
            row_height_list.append(row_height)
            current_y += row_height
        return row_height_list

    def get_col_properties(self):
        # only default properties allowed
        return self.default_properties

    def get_col_widths(self, start_x, w):
        # for now fixed size
        col_width = self.default_properties.find_property('width')

        current_x = start_x
        col_width_list = []
        while current_x < w:
            col_width_list.append(col_width)
            current_x += col_width
        return col_width_list

    def load_from_csv(self, filename):
        f = open(filename, 'rb')
        reader = csv.reader(f)
        row_num = 0
        for row in reader:
            col_num = 0
            for col in row:
                if col == "":
                    #print "[-]",
                    pass
                else:
                    #print "[%s]" % col,
                    cell = TextContent(col)
                    self.add_cell(col_num, row_num, cell)
                col_num += 1
            #print ""
            row_num += 1

        f.close()
                
        
class RowHeader(object):
    def __init__(self):
        # create empty dict for the cells in this row, the key for the cell
        # will be the col_nr
        self.cells = {}

    def get_cell(self, col_nr):
        if col_nr in self.cells:
            return self.cells[col_nr]
        else:
            return None

    def add_cell(self, col_nr, cell):
        if col_nr in self.cells:
            del self.cells[col_nr]
        self.cells[col_nr] = cell

    def del_cell(self, col_nr):
        del self.cells[col_nr]

class Cell(object):
    def __init__(self, props, content):
        self.props = props
        self.content = content

    def get_content(self):
        return self.content

    def get_props(self):
        return self.props

    def find_property(self, key):
        if self.props != None:
            return self.props.find_property(key)

class Properties(object):
    def __init__(self, base=None, left=-1, top=-1, right=-1, bottom=-1):
        # list is a dictionary with prop-value
        self.list = {}
        self.base = base
        self.left = left
        self.top = top
        self.right = right
        self.bottom = bottom

    def add_prop(self, key, value):
        # todo: check if property is in base and has same value?
        self.list[key] = value

    def find_property(self, key):
        if key in self.list:
            return self.list[key]
        elif self.base != None:
            return self.base.find_property(key)

class Content(object):
    def __init__(self):
        self.type = None

    def get_value(self):
        pass

    def get_content(self):
        pass

class TextContent(Content):
    def __init__(self, text):
        self.text = text

    def get_value(self):
        return self.text

    def get_content(self):
        return self.text

class ValueContent(Content):
    def __init__(self, value):
        self.value = value
        
    def get_value(self):
        return self.value

    def get_content(self):
        return self.value

class FormulaContent(Content):
    def __init__(self, formula):
        self.formula = formula
        
    def get_value(self):
        #todo: evaluate formula
        return self.formula

    def get_content(self):
        return self.formula

    
#------------------- Unit test --------------------
   
if __name__ == "__main__":
    # We create a dictionary of rows for our test
    rows = {}
    rows[0] = RowHeader()
    rows[1] = RowHeader()
    rows[2] = RowHeader()

    # First we need some properties
    base_row_props = Properties(None)
    base_row_props.add_prop('name', 'row')
    base_row_props.add_prop('width', 100)

    base_col_props = Properties(base_row_props)
    base_col_props.add_prop('name', 'column')
    base_col_props.add_prop('height', 20)

    base_props = Properties(base_col_props)
    base_props.add_prop('name', 'default')
    base_props.add_prop('font_size', 10)
    base_props.add_prop('fg_color', 0xffffff)
    base_props.add_prop('bg_color', 0x000000)

    props = Properties(base_props)
    props.add_prop('name', 'cell')
    props.add_prop('fg_color', 0x808080)

    # Now create some cells and add them to row
    sheet = Sheet('Test Sheet')
    cell1 = Cell(base_props, TextContent('Test1'))
    sheet.add_cell(0, 1, cell1) # A2
    cell2 = Cell(base_props, FormulaContent('A1+3'))
    sheet.add_cell(1, 0, cell1) # B1
    cell3 = Cell(props, TextContent('Test3'))
    sheet.add_cell(2, 2, cell1) # C3
    cell4 = Cell(props, ValueContent(3.14))
    sheet.add_cell(0, 0, cell1) # A1

    def print_cell(cell, name):
        print 'Name: %s' % name
        width = cell.find_property('width')
        height = cell.find_property('height')
        col = cell.find_property('fg_color')
        print 'Width:%d Height:%d Color:%x' %(width, height, col)
        print 'Value: ',
        print cell.get_content().get_value()
        
    print_cell(cell1, 'cell1')
    print_cell(cell2, 'cell2')
    print_cell(cell3, 'cell3')
    print_cell(cell4, 'cell4')
    

    
    
