﻿# -*- coding: utf-8 -*-

__license__   = 'GPL v3'
__copyright__ = '2012, Michael Scalet <scalet@gmail.com>'
__docformat__ = 'restructuredtext en'

'''
Device driver for Infibeam Pi2
'''

import os

from calibre.devices.usbms.driver import USBMS, debug_print

class PI2(USBMS):

    name           = 'Infibeam Pi2'
    gui_name       = _('Infibeam Pi2')
    author         = 'Michael Scalet'
    description    = _('Communicate with the Infibeam Pi2 reader.')
    version        = (1,0,0)
    supported_platforms = ['windows', 'osx', 'linux']

    # Ordered list of supported formats
    FORMATS     = ['epub', 'mobi', 'prc', 'html', 'htm', 'doc', 'pdf', 'rtf', 'txt']

    VENDOR_ID   = [0x1F85]
    PRODUCT_ID  = [0x1688]
    BCD         = [0x0110]

    EBOOK_DIR_MAIN = EBOOK_DIR_CARD_A = ''

    VENDOR_NAME      = 'INFIBEAM'
    WINDOWS_MAIN_MEM = 'INFIBEAM_PI'
    WINDOWS_CARD_A_MEM = 'INFIBEAM_PI'

    #OSX_MAIN_MEM = 'Infibeam Pi'

    MAIN_MEMORY_VOLUME_LABEL  = 'Infibeam Pi'

    SUPPORTS_SUB_DIRS = True

    def delete_books(self, paths, end_session=True):
        debug_print('Pi2: deleting %d books'%(len(paths)))
        opts = self.settings()
        for i, path in enumerate(paths):
            self.report_progress((i+1) / float(len(paths)), _('Removing books from device...'))
            path = self.normalize_path(path)
            folder = os.path.split(path)[0]
            file = os.path.split(path)[1]
            file = os.path.splitext(file)[0]
            if os.path.exists(path):
                # Delete the ebook
                os.unlink(path)
                debug_print('Pi2: Removed '+path)
            debug_print('Pi2: Trying to remove '+ os.path.join(folder,file+'.rec'))
            if os.path.exists(os.path.join(folder,file+'.rec')):
                # Delete info file
                os.unlink(os.path.join(folder,file+'.rec'))
                debug_print('Pi2: Removed '+os.path.join(folder,file+'.rec'))
            debug_print('Pi2: Trying to remove folder if empty :'+ folder)
            try:
                # Remove folder and all parents if empty
                os.removedirs(folder)
                debug_print('Pi2: Removed '+folder)
            except:
                # folder was not empty, ignore
                pass
				 
             
             


        self.report_progress(1.0, _('Removing books from device...'))
        debug_print('OYO: finished deleting %d books'%(len(paths)))

