/*
 solaris: gcc -shared -fPIC -o libfoo.so -L/usr/local/lib -Wl,-R/usr/local/lib -I/usr/local/include foo.c
 linux: gcc -shared -fPIC -o libfoo.so foo.c
 macos lion: gcc -m32 -bundle -fPIC -o libfoo.so foo.c
 cygwin: gcc -shared -o libfoo.so foo.c -lsqlite3
 */
#include <stdio.h>
#include <sqlite3ext.h>
SQLITE_EXTENSION_INIT1

//is_journaling_enabled
static
void
ije(sqlite3_context *context, int argc, sqlite3_value **argv)
	{
	sqlite3_result_int(context, 0);
	}

//json_string
static
void
js(sqlite3_context *context, int argc, sqlite3_value **argv)
	{
	const char *z = sqlite3_value_text(argv[0]);
	sqlite3_result_text(context, z, -1, SQLITE_TRANSIENT);
	}

//get_language_from_titles
static
void
glft(sqlite3_context *context, int argc, sqlite3_value **argv)
	{
	sqlite3_result_text(context, "en", -1, SQLITE_STATIC);
	}

//uuid
static
void
gu(sqlite3_context *context, int argc, sqlite3_value **argv)
	{
	const char *z = sqlite3_value_text(argv[0]);
	char buf[64];
	int i, j;
	for (i = 0, j = 0; i < 32; ++i, ++j)
		{
		buf[j] = z[i];
		if (i == 7 || i == 11 || i == 15 || i == 19)
			buf[++j] = '-';
		}
	buf[j] = 0x00;
	sqlite3_result_text(context, buf, -1, SQLITE_TRANSIENT);
	}

//COLLATE icu
static
int
tc(void* p, int a_len, const void* a, int b_len, const void* b)
	{
	int len = (a_len < b_len) ? a_len : b_len;
	int n = sqlite3_strnicmp(a,b,len);
	if (n != 0)
		return n;
	if (a_len > b_len)
		return 1;
	if (a_len < b_len)
		return -1;
	return 0;
	}

int
sqlite3_extension_init(sqlite3 *db, char **pzErrMsg,
					   const sqlite3_api_routines *pApi)
	{
	SQLITE_EXTENSION_INIT2(pApi)
	if ( sqlite3_create_function(db, "is_journaling_enabled", 0, SQLITE_ANY, NULL, &ije, NULL, NULL) )
		{
		*pzErrMsg = sqlite3_mprintf("Can't create function: %s\n", sqlite3_errmsg(db));
		return SQLITE_ERROR;
		}
	if ( sqlite3_create_function(db, "json_string", 1, SQLITE_ANY, NULL, &js, NULL, NULL) )
		{
		*pzErrMsg = sqlite3_mprintf("Can't create function: %s\n", sqlite3_errmsg(db));
		return SQLITE_ERROR;
		}
	if ( sqlite3_create_function(db, "get_language_from_titles", 1, SQLITE_ANY, NULL, &glft, NULL, NULL) )
		{
		*pzErrMsg = sqlite3_mprintf("Can't create function: %s\n", sqlite3_errmsg(db));
		return SQLITE_ERROR;
		}
	if ( sqlite3_create_function(db, "uuidize", 1, SQLITE_UTF8, NULL, &gu, NULL, NULL) )
		{
		*pzErrMsg = sqlite3_mprintf("Can't create function: %s\n", sqlite3_errmsg(db));
		return SQLITE_ERROR;
		}
	if ( sqlite3_create_collation(db, "icu", SQLITE_UTF8, NULL, &tc) )
		{
		*pzErrMsg = sqlite3_mprintf("Can't create collation: %s\n", sqlite3_errmsg(db));
		return SQLITE_ERROR;
		}
	return SQLITE_OK;
}

