#!/bin/sh
# ds = current status of duokan process
# ks = current status of kindle process
# status starts with S if the process is active, T if the process is stopped,
# and nothing if the process is not found
eips -c
ds=$(ps -e j | grep -v awk | awk '/KindleApp/ { print $7 }')
ks=$(ps -e j | grep -v awk | awk '/cvm/ { print $7 }')
eips 0 20 "From DS: $ds KS: $ks" 

case $ks in
T*) 
;;
S*) 
dbus-send --system /default com.lab126.powerd.userShutdown int32:1
wait 3
kstop=$(killall -STOP cvm)
if [ $kstop -ne 0 ]
then
eips 0 22 "$kstop Error sending Kindle STOP"
sleep 1
fi
;;
*) 
;;
esac

case $ds in
T*)
dcont=$(killall -cont KindleApp)
if [ $dcont -ne 0 ]
then
eips 0 23 "$dcont Error sending Duokan CONT"
sleep 1
fi
;;
S*)
;;
*)
# if duokan lite process not found at all, start it
# environment variables required by duokan lite
DUOKAN_SYS_PATH="/DuoKan"
RUN_TAG="$DUOKAN_SYS_PATH/duokantag"
DUOKAN_USER_PATH="/mnt/us/DK_System/xKindle"
APP_LITE_NOTFOND_RET="100"
APP_EBOOK_NOTFOND_RET="110"
DUOKAN_TAG_OLD="ebook"
DUOKAN_TAG="duokan"
KINDLE_TAG="kindle"
#/etc/rc5.d/S95framework stop
cd $DUOKAN_SYS_PATH		
LD_LIBRARY_PATH=.:$DUOKAN_SYS_PATH/lib/:../lib/:${LD_LIBRARY_PATH}
FONTCONFIG_PATH=$DUOKAN_SYS_PATH/res/fontconfig
export LD_LIBRARY_PATH
export FONTCONFIG_PATH
./KindleApp
;;
esac
#sleep 4
#dbus-send --system /default com.lab126.powerd.resuming int32:1
#sleep 1
#dbus-send --system /default com.lab126.powerd.usbPlugOut int32:1