#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ptrace.h>
#include <asm/ptrace.h>



int main( int argc, char *argv[] )
{
	int i;
	pid_t p;

	if (!(p=fork()))
	{
		ptrace(PTRACE_TRACEME, 0, 0, 0);
		execv( argv[1], &argv[2] );
	}

	int status, io = 0;

	waitpid( p, &status, 0 );
	while( ptrace( PTRACE_SYSCALL, p, 0, 0 ) == 0 )
	{
		struct pt_regs regs;
		int i, len;
		unsigned int data;

		waitpid( p, &status, 0 );
		if( WIFEXITED( status ) )
		{
			printf("exit\n" );
			break;
		}
		
		ptrace(PTRACE_GETREGS, p, 0, &regs);

		printf("enter/leave syscall %lx\n Regs: ", regs.uregs[7] );
		for( i = 0; i < 8; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n       ");
		for( i = 8; i < 16; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n       ");
		for( i = 16; i < 18; i ++ )
			printf( "0x%08lx ", regs.uregs[i] );
		printf("\n");
		
		// List of syscall number is defined in kernel_source_root/arch/arm/include/asm/asm/unistd.h
		switch( regs.uregs[7] )
		{
		case 0x00000036: // ioctl
			len = ( regs.uregs[1] & 0x1FFF0000 ) >> 16;
			printf( " ioctl 0x%08lx ( sizeof(arg) = %d )\n", regs.uregs[1], len );
			if( len > 0 )
			{
				printf( " Memdump: 0x%08lx", regs.uregs[2] );
				for( i = 0; i < len; i ++ )
				{
					if( i % 8 == 0 )
					{
						printf("\n  ");
					}
					data = ptrace( PTRACE_PEEKDATA, p, (void*)( regs.uregs[2] + i ), &data );
					printf( "%02lx ", data & 0xFF );
				}
				printf("\n");
			}
		}

		fflush(stdout);
	}
	return 0;
}
