#!/usr/bin/perl
use strict;
use warnings;

open FIND, "find . -type f -name '*.js'|grep -v locales|" or die $!;
while (<FIND>) {
	my $from = $_;
	chomp $from;
	
	my ($dir, $file);	
	if ($from =~ /(^.*)\/(.*)\.js$/) {
		($dir, $file) = ($1, $2);
	} else {
		die "This should not happen, input: $from";
	}

	my $template = "$dir/${file}.tjs";
	my $properties = "$dir/locales/en_US";
	die "Please create directory $properties" unless -d $properties;

	$properties.="/$file.properties";
	system "perl js2template.pl $from $template $properties";
}
