/**
 * Object that contains localized strings and objects used by the browser
 * application
 * @member bapp
 */
bapp.strings = {
    /**
     * Browser error messages
     */
    error: {
        na: 'not implemented',
        badProtocol: 'Web Browser cannot download files using this protocol. &nbsp;Only HTTP and HTTPS protocols are supported.',
        downloadFailed: 'Web Browser was unable to download {filename}. &nbsp;Please try again later.',
        downloadRejected: 'Web Browser cannot download this kind of file.<p>Only files with the extension .AZW, .PRC, .MOBI or .TXT can be downloaded to your Kindle.</p>',
        uploadRejected: 'Web Browser does not support file uploads.',
        register: 'In order to browse using 3G wireless, you must first register your Kindle to your Amazon user account.',
        confirmSsl: 'Web Browser is unable to establish a secure connection.  Do you still want to proceed?',
        blockedDomain: 'Web Browser requires a Wi-Fi connection. &nbsp;Tap Ok to establish a Wi-Fi connection.',
        noAccess: 'Sorry, the browser cannot access this website.',
        accountError: 'There is a problem with your Kindle account. Please contact Customer Service at www.kindle.com/support.',
        systemFailure: 'We are experiencing some technical difficulties. Please try again later.',
        remoteFailure: 'Sorry, the browser cannot access this website at this time. &nbsp;Please try again later.',
        accessEmbargo: 'Due to local restrictions, web browsing is not available for all countries.',
        appInvalid: 'Sorry, application is invalid.',
        roamingBlocked: 'Sorry, roaming is not allowed.',
        deviceBlocked: 'Sorry, the device was blocked.',
        appBlocked: 'Sorry, the application was blocked.',
        quotaExceeded: 'Sorry, the application has exceeded its quota.',
        accessBlocked: 'Sorry, access to whispernet is blocked.'
    },

    /**
     * Browser menu page and dialog titles
     */
    title: {
        main: 'Menu',
        bkmarks: 'Bookmarks',
        editBkmark: 'Edit Bookmark',
        delBkmark: 'Remove a Bookmark',
        history: 'History',
        settings: 'Settings',
        search: 'Search',
        downloadFile: 'Download File',
        downloadFailed: 'Download Failed',
        downloadRejected: 'Invalid File Type',
        badProtocol: 'Invalid Protocol',
        uploadFile: 'Upload File',
        register: 'Registration Required',
        confirmSsl: 'Invalid Certificate',
        duplicateBookmark: 'Duplicate Bookmark',
        blockedDomain: 'Wi-Fi Connection Required',
        httpError: 'Website Unaccessible'
    },

    /**
     * Browser button labels
     */
    btn: {
        close: 'Close',
        cancel: 'Cancel',
        del: 'Remove',
        save: 'Save',
        edit: 'Edit',
        clear: 'Clear',
        disable: 'Disable',
        enable: 'Enable',
        menu: 'Menu',
        goTo: 'Go to',
        search: 'Search',
        cancelX: 'X',
        ok: 'OK',
        done: 'Done',
        ignore: 'Ignore All',
        register: 'Register'
    },

    /**
     * Browser menu item labels
     */
    item: {
        shop: 'Shop in Kindle Store',
        turnWirelessOff: 'Turn Off Wireless',
        turnWirelessOn: 'Turn On Wireless',
        lockRotation: 'Lock Rotation',
        unlockRotation: 'Unlock Rotation',
        article: 'Article Mode',
        webMode: 'Web Mode',
        bkmarks: 'Bookmarks',
        bkmarkPage: 'Bookmark this Page',
        delBkmark: 'Remove a Bookmark',
        editBkmark: 'Edit a Bookmark',
        history: 'History',
        settings: 'Browser Settings',
        clearHistory: 'Clear History',
        clearCookies: 'Clear Cookies',
        enableJs: 'Enable JavaScript',
        disableJs: 'Disable JavaScript',
        enableImgs: 'Enable Images',
        disableImgs: 'Disable Images',
        todayFormat: 'Today - {date}',
        yesterdayFormat: 'Yesterday - {date}'
    },

    /**
     * Browser messages that are not errors
     */
    message: {
        downloadConfirm: 'Download {filename}?<br><br>Once the download is complete, the file will appear in Home. &nbsp;Are you sure you wish to proceed?',
        downloadSuccess: 'Web Browser successfully downloaded {filename}.',
        duplicateBookmark: 'Another page with the same URL is already bookmarked.<br><br>Do you wish to overwrite it?'
    },

    /**
     * Default Bookmarks - TODO: Determine what these should be or where to get
     * them
     */
    defBkmarks: [
        {
            name: 'Amazon',
            url: 'http://www.amazon.com'
        },
        {
            name: 'Amazon UK',
            url: 'http://www.amazon.co.uk'
        },
        {
            name: 'Wikipedia',
            url: 'http://en.wikipedia.org'
        },
        {
            name: 'Google',
            url: 'http://www.google.com'
        },
        {
            name: 'Gmail',
            url: 'http://mail.google.com/mail/'
        },
        {
            name: 'Yahoo',
            url: 'http://www.yahoo.com'
        },
        {
            name: 'Yahoo Mail',
            url: 'http://m.yahoo.com/mail'
        },
        {
            name: 'New York Times',
            url: 'http://www.nytimes.com'
        },
        {
            name: 'BBC',
            url: 'http://www.bbc.co.uk'
        },
        {
            name: 'Facebook',
            url: 'http://touch.facebook.com'
        },
        {
            name: 'Twitter',
            url: 'http://twitter.com'
        }
    ],

    /**
     * Actions available to browsers go function
     */
    goActions: {
        website: {
            label: 'Web',
            description: 'Web Address',
        },
        google: {
            label: 'Google',
            description: 'Google',
            url: 'http://www.google.com/search?q=',
        },
        wikipedia: {
            label: 'Wikipedia',
            description: 'Wikipedia',
            url: 'http://en.wikipedia.org/w/index.php?title=Special:Search&search=',
        },
    },
};
