package ixtab.kindlet;

import ixtab.jailbreak.SuicidalKindlet;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.amazon.kindle.kindlet.KindletContext;
import com.amazon.kindle.kindlet.internal.StandardKindletContext;
import com.amazon.kindle.kindlet.ui.ToolbarStyle;

public class SampleKindlet extends SuicidalKindlet implements ActionListener {

	private KindletContext context;
	private JLabel label = new JLabel("status");
	private JButton button = new JButton("toggle menu");
	private boolean showing = true;
	
	public SampleKindlet() {
	}

	@Override
	public void onCreate(KindletContext context) {
		this.context = context;
		initUI();
	}

	private void initUI() {
		Container root = context.getRootContainer();
		root.setLayout(new BorderLayout());
		JPanel middle = new JPanel(new FlowLayout(FlowLayout.CENTER, 20, 20));
		middle.add(button);
		root.add(middle, BorderLayout.CENTER);
		root.add(label, BorderLayout.SOUTH);
		
		button.addActionListener(this);
		updateLabel();
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		showing = !showing;
		updateLabel();
	}

	private void updateLabel() {
		String result = "Wrong context";
		if (context instanceof StandardKindletContext) {
			result = "Menu is " + (showing ? "shown":"hidden");
			ToolbarStyle style = showing ? ToolbarStyle.TOOLBAR_PERSISTENT : ToolbarStyle.TOOLBAR_NONE;
			((StandardKindletContext)context).getToolbar().setToolbarStyle(style);
		}
		label.setText(result);
		label.repaint();
	}
	
	
}