/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.java.util.regex._Matcher;
import net.sf.retrotranslator.transformer.EmbeddingConverter;
import net.sf.retrotranslator.transformer.ReplacementLocatorFactory;

class TextFileTransformer {
    private static Pattern pattern = Pattern.compile("([A-Za-z_$][A-Za-z0-9_$]*\\.)+[A-Za-z_$][A-Za-z0-9_$]*");
    private final ReplacementLocatorFactory factory;
    private final EmbeddingConverter converter;

    public TextFileTransformer(ReplacementLocatorFactory factory, EmbeddingConverter converter) {
        this.factory = factory;
        this.converter = converter;
    }

    public byte[] transform(byte[] bytes) {
        boolean modified = false;
        Matcher matcher = pattern.matcher(TextFileTransformer.toString(bytes));
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String name;
            String originalName = matcher.group().replace('.', '/');
            String backportName = this.factory.getLocator().getReferenceTypeName(originalName);
            String string = name = this.converter == null ? backportName : this.converter.convertClassName(backportName);
            if (originalName.equals(name)) {
                matcher.appendReplacement(buffer, "$0");
                continue;
            }
            modified = true;
            matcher.appendReplacement(buffer, _Matcher.quoteReplacement(RuntimeTools.getDisplayClassName(name)));
        }
        return modified ? TextFileTransformer.toBytes(matcher.appendTail(buffer).toString()) : bytes;
    }

    private static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

