/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.transformer.AbstractMethodVisitor;
import net.sf.retrotranslator.transformer.ClassReplacement;
import net.sf.retrotranslator.transformer.InstantiationFrame;
import net.sf.retrotranslator.transformer.InstantiationPoint;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.SystemLogger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstantiationAnalysisVisitor
extends ClassAdapter {
    private final ReplacementLocator locator;
    private final Map<String, List<InstantiationPoint>> pointListMap;
    private final SystemLogger logger;
    private String thisName;
    private String superName;

    public InstantiationAnalysisVisitor(ClassVisitor visitor, ReplacementLocator locator, Map<String, List<InstantiationPoint>> pointListMap, SystemLogger logger) {
        super(visitor);
        this.locator = locator;
        this.pointListMap = pointListMap;
        this.logger = logger;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.thisName = name;
        this.superName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return visitor == null ? null : new InstantiationAnalysisMethodVisitor(visitor, name, desc);
    }

    private class InstantiationAnalysisMethodVisitor
    extends AbstractMethodVisitor {
        private final List<InstantiationPoint> points;
        private final Map<Label, InstantiationFrame> frames;
        private InstantiationFrame currentFrame;
        private final String methodName;
        private final String methodDesc;
        private boolean active;
        private InstantiationPoint currentPoint;
        private int allocationIndex;
        private int duplicationIndex;
        private int initializationIndex;

        public InstantiationAnalysisMethodVisitor(MethodVisitor visitor, String methodName, String methodDesc) {
            super(visitor);
            this.points = new ArrayList<InstantiationPoint>();
            this.frames = new HashMap<Label, InstantiationFrame>();
            this.active = true;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.currentFrame = new InstantiationFrame(!methodName.equals("<init>"));
        }

        protected void flush() {
            this.currentPoint = null;
        }

        public void visitLabel(Label label) {
            super.visitLabel(label);
            InstantiationFrame frame = this.frames.remove(label);
            if (frame != null) {
                this.currentFrame = frame;
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            this.saveFrame(label);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            this.saveFrames(dflt, labels);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            this.saveFrames(dflt, labels);
        }

        private void saveFrames(Label label, Label[] labels) {
            this.saveFrame(label);
            Label[] arr$ = labels;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Label currentLabel = arr$[i$];
                this.saveFrame(currentLabel);
            }
        }

        private void saveFrame(Label label) {
            if (!this.frames.containsKey(label)) {
                this.frames.put(label, new InstantiationFrame(this.currentFrame));
            }
        }

        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            if (opcode == 187 && this.active) {
                this.currentPoint = new InstantiationPoint(desc, ++this.allocationIndex);
                this.currentFrame.addLast(this.currentPoint);
            }
        }

        public void visitInsn(int opcode) {
            if (opcode == 89 && this.active) {
                ++this.duplicationIndex;
                if (this.currentPoint != null) {
                    this.currentPoint.setDuplicationIndex(this.duplicationIndex);
                }
            }
            super.visitInsn(opcode);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            ClassReplacement classReplacement;
            super.visitMethodInsn(opcode, owner, name, desc);
            if (opcode != 183 || !name.equals("<init>") || !this.active) {
                return;
            }
            ++this.initializationIndex;
            InstantiationPoint point = this.currentFrame.pollLast();
            if (point != null) {
                if (!owner.equals(point.getInternalName()) || point.getInitializationIndex() != 0) {
                    this.active = false;
                    return;
                }
            } else {
                if (this.currentFrame.isInitialized() || !owner.equals(InstantiationAnalysisVisitor.this.thisName) && !owner.equals(InstantiationAnalysisVisitor.this.superName)) {
                    this.active = false;
                    return;
                }
                this.currentFrame.setInitialized(true);
            }
            if ((classReplacement = InstantiationAnalysisVisitor.this.locator.getReplacement(owner)) == null) {
                return;
            }
            MemberReplacement memberReplacement = classReplacement.getInstantiationReplacements().get(desc);
            if (memberReplacement == null) {
                return;
            }
            if (point == null || point.getDuplicationIndex() == 0) {
                InstantiationAnalysisVisitor.this.logger.logForFile(Level.WARNING, "Cannot translate " + RuntimeTools.getDisplayClassName(owner) + " constructor call in " + this.methodName + " method.");
                return;
            }
            point.setInitializationIndex(this.initializationIndex);
            point.setReplacement(memberReplacement);
            this.points.add(point);
        }

        public void visitEnd() {
            super.visitEnd();
            if (this.active) {
                if (!this.points.isEmpty()) {
                    InstantiationAnalysisVisitor.this.pointListMap.put(this.methodName + this.methodDesc, this.points);
                }
            } else {
                InstantiationAnalysisVisitor.this.logger.logForFile(Level.INFO, "Cannot analyze " + this.methodName + " method.");
            }
        }
    }
}

