/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Attribute;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.transformer.AbstractMethodVisitor;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.TransformerTools;

abstract class GenericClassVisitor
extends NameTranslator
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public GenericClassVisitor(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classVisitor.visit(version, access, this.typeName(name), this.declarationSignature(signature), this.typeName(superName), this.typeNames(interfaces));
    }

    public void visitSource(String source, String debug) {
        this.classVisitor.visitSource(source, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.classVisitor.visitOuterClass(this.typeName(owner), this.identifier(name), this.methodDescriptor(desc));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.wrap(this.classVisitor.visitAnnotation(this.typeDescriptor(desc), visible));
    }

    public void visitAttribute(Attribute attr) {
        this.classVisitor.visitAttribute(attr);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.classVisitor.visitInnerClass(this.typeName(name), this.typeName(outerName), this.identifier(innerName), access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor result = this.classVisitor.visitField(access, this.identifier(name), this.typeDescriptor(desc), this.typeSignature(signature), value);
        return result == null ? null : new GenericFieldVisitor(result);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor result = this.classVisitor.visitMethod(access, this.identifier(name), this.methodDescriptor(desc), this.declarationSignature(signature), this.typeNames(exceptions));
        return result == null ? null : new GenericMethodVisitor(result);
    }

    protected void visitTypeInstruction(MethodVisitor visitor, int opcode, String desc) {
        visitor.visitTypeInsn(opcode, this.typeNameOrDescriptor(desc));
    }

    protected void visitFieldInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        visitor.visitFieldInsn(opcode, this.typeName(owner), this.identifier(name), this.typeDescriptor(desc));
    }

    protected void visitMethodInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        visitor.visitMethodInsn(opcode, this.typeNameOrDescriptor(owner), this.identifier(name), this.methodDescriptor(desc));
    }

    public void visitEnd() {
        this.classVisitor.visitEnd();
    }

    private AnnotationVisitor wrap(AnnotationVisitor av) {
        return av == null ? null : new GenericAnnotationVisitor(av);
    }

    private class GenericMethodVisitor
    extends AbstractMethodVisitor {
        private String deferredConstant;
        static /* synthetic */ Class class$java$lang$Class;
        static /* synthetic */ Class class$java$lang$String;

        public GenericMethodVisitor(MethodVisitor visitor) {
            super(visitor);
        }

        protected void flush() {
            if (this.deferredConstant != null) {
                this.mv.visitLdcInsn(this.deferredConstant);
                this.deferredConstant = null;
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return GenericClassVisitor.this.wrap(super.visitAnnotationDefault());
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return GenericClassVisitor.this.wrap(super.visitAnnotation(GenericClassVisitor.this.typeDescriptor(desc), visible));
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return GenericClassVisitor.this.wrap(super.visitParameterAnnotation(parameter, GenericClassVisitor.this.typeDescriptor(desc), visible));
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.flush();
            GenericClassVisitor.this.visitTypeInstruction(this.mv, opcode, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.flush();
            GenericClassVisitor.this.visitFieldInstruction(this.mv, opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.deferredConstant != null && this.deferredConstant.indexOf(47) < 0 && opcode == 184 && name.equals("class$")) {
                Class<?> clazz = class$java$lang$Class;
                if (clazz == null) {
                    clazz = class$java$lang$Class = new Class[0].getClass().getComponentType();
                }
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = classArray[0] = (class$java$lang$String = new String[0].getClass().getComponentType());
                }
                if (desc.equals(TransformerTools.descriptor(clazz, classArray))) {
                    this.deferredConstant = GenericClassVisitor.this.classLiteralNameOrDescriptor(this.deferredConstant.replace('.', '/')).replace('/', '.');
                }
            }
            this.flush();
            GenericClassVisitor.this.visitMethodInstruction(this.mv, opcode, owner, name, desc);
        }

        public void visitLdcInsn(Object cst) {
            this.flush();
            if (cst instanceof String) {
                this.deferredConstant = (String)cst;
            } else {
                this.mv.visitLdcInsn(GenericClassVisitor.this.classLiteralTypeOrValue(cst));
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(GenericClassVisitor.this.typeDescriptor(desc), dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            super.visitTryCatchBlock(start, end, handler, GenericClassVisitor.this.typeName(type));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(GenericClassVisitor.this.identifier(name), GenericClassVisitor.this.typeDescriptor(desc), GenericClassVisitor.this.typeSignature(signature), start, end, index);
        }
    }

    private class GenericFieldVisitor
    implements FieldVisitor {
        private FieldVisitor fieldVisitor;

        public GenericFieldVisitor(FieldVisitor fieldVisitor) {
            this.fieldVisitor = fieldVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return GenericClassVisitor.this.wrap(this.fieldVisitor.visitAnnotation(GenericClassVisitor.this.typeDescriptor(desc), visible));
        }

        public void visitAttribute(Attribute attr) {
            this.fieldVisitor.visitAttribute(attr);
        }

        public void visitEnd() {
            this.fieldVisitor.visitEnd();
        }
    }

    private class GenericAnnotationVisitor
    implements AnnotationVisitor {
        private AnnotationVisitor annotationVisitor;

        public GenericAnnotationVisitor(AnnotationVisitor annotationVisitor) {
            this.annotationVisitor = annotationVisitor;
        }

        public void visit(String name, Object value) {
            this.annotationVisitor.visit(GenericClassVisitor.this.identifier(name), GenericClassVisitor.this.classLiteralTypeOrValue(value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.annotationVisitor.visitEnum(GenericClassVisitor.this.identifier(name), GenericClassVisitor.this.typeDescriptor(desc), value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return GenericClassVisitor.this.wrap(this.annotationVisitor.visitAnnotation(GenericClassVisitor.this.identifier(name), GenericClassVisitor.this.typeDescriptor(desc)));
        }

        public AnnotationVisitor visitArray(String name) {
            return GenericClassVisitor.this.wrap(this.annotationVisitor.visitArray(GenericClassVisitor.this.identifier(name)));
        }

        public void visitEnd() {
            this.annotationVisitor.visitEnd();
        }
    }
}

