/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int c) {
        return c & 0xE0000000;
    }

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    private static int ctlOf(int rs, int wc) {
        return rs | wc;
    }

    private static boolean runStateLessThan(int c, int s) {
        return c < s;
    }

    private static boolean runStateAtLeast(int c, int s) {
        return c >= s;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    private boolean compareAndIncrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect + 1);
    }

    private boolean compareAndDecrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect - 1);
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    private void advanceRunState(int targetState) {
        int c;
        while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(targetState, ThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    final void tryTerminate() {
        int c;
        while (!(ThreadPoolExecutor.isRunning(c = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || ThreadPoolExecutor.runStateOf(c) == 0 && !this.workQueue.isEmpty())) {
            Object var6_3;
            if (ThreadPoolExecutor.workerCountOf(c) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(0x40000000, 0))) {
                    try {
                        this.terminated();
                        Object var4_4 = null;
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                        this.termination.signalAll();
                        throw throwable;
                    }
                    var6_3 = null;
                    mainLock.unlock();
                    return;
                }
                var6_3 = null;
                mainLock.unlock();
            }
            catch (Throwable throwable) {
                var6_3 = null;
                mainLock.unlock();
                throw throwable;
            }
        }
        return;
    }

    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    security.checkAccess(w.thread);
                }
                Object var6_5 = null;
                mainLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                mainLock.unlock();
                throw throwable;
            }
        }
    }

    private void interruptWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                try {
                    w.thread.interrupt();
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            Object var6_5 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator it = this.workers.iterator();
            do {
                Object var8_7;
                if (!it.hasNext()) {
                    break;
                }
                Worker w = (Worker)it.next();
                Thread t = w.thread;
                if (t.isInterrupted() || !w.tryLock()) continue;
                try {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException ignore) {
                        var8_7 = null;
                        w.unlock();
                        continue;
                    }
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    w.unlock();
                    throw throwable;
                }
                w.unlock();
            } while (!onlyOne);
            Object var10_9 = null;
            mainLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    private void clearInterruptsForTaskRun() {
        if (ThreadPoolExecutor.runStateLessThan(this.ctl.get(), 0x20000000) && Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) {
            Thread.currentThread().interrupt();
        }
    }

    final void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean shutdownOK) {
        int rs = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return rs == -536870912 || rs == 0 && shutdownOK;
    }

    private List drainQueue() {
        BlockingQueue q = this.workQueue;
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        q.drainTo(taskList);
        if (!q.isEmpty()) {
            Runnable[] arr = q.toArray(new Runnable[0]);
            int i = 0;
            while (i < arr.length) {
                Runnable r = arr[i];
                if (q.remove(r)) {
                    taskList.add(r);
                }
                ++i;
            }
        }
        return taskList;
    }

    private boolean addWorker(Runnable firstTask, boolean core) {
        block2: while (true) {
            int c;
            int rs;
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs != 0 || firstTask != null || this.workQueue.isEmpty())) {
                return false;
            }
            do {
                int wc;
                if ((wc = ThreadPoolExecutor.workerCountOf(c)) >= 0x1FFFFFFF || wc >= (core ? this.corePoolSize : this.maximumPoolSize)) {
                    return false;
                }
                if (this.compareAndIncrementWorkerCount(c)) break block2;
            } while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
        }
        Worker w = new Worker(firstTask);
        Thread t = w.thread;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int c = this.ctl.get();
            int rs = ThreadPoolExecutor.runStateOf(c);
            if (t == null || rs >= 0 && (rs != 0 || firstTask != null)) {
                this.decrementWorkerCount();
                this.tryTerminate();
                boolean bl = false;
                Object var10_13 = null;
                mainLock.unlock();
                return bl;
            }
            this.workers.add(w);
            int s = this.workers.size();
            if (s > this.largestPoolSize) {
                this.largestPoolSize = s;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            mainLock.unlock();
            throw throwable;
        }
        Object var10_14 = null;
        mainLock.unlock();
        t.start();
        if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x20000000 && !t.isInterrupted()) {
            t.interrupt();
        }
        return true;
    }

    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
            Object var5_4 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mainLock.unlock();
            throw throwable;
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                int min;
                int n = min = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(c) >= min) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean timedOut = false;
        while (true) {
            boolean timed;
            block6: {
                int c;
                int rs;
                if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs >= 0x20000000 || this.workQueue.isEmpty())) {
                    this.decrementWorkerCount();
                    return null;
                }
                do {
                    int wc = ThreadPoolExecutor.workerCountOf(c);
                    boolean bl = timed = this.allowCoreThreadTimeOut || wc > this.corePoolSize;
                    if (wc <= this.maximumPoolSize && (!timedOut || !timed)) break block6;
                    if (!this.compareAndDecrementWorkerCount(c)) continue;
                    return null;
                } while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
                continue;
            }
            try {
                Runnable r;
                Runnable runnable = r = timed ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take();
                if (r != null) {
                    return r;
                }
                timedOut = true;
                continue;
            }
            catch (InterruptedException retry) {
                timedOut = false;
                continue;
            }
            break;
        }
    }

    final void runWorker(Worker w) {
        Runnable task = w.firstTask;
        w.firstTask = null;
        boolean completedAbruptly = true;
        try {
            while (task != null || (task = this.getTask()) != null) {
                Object var11_6;
                w.lock();
                this.clearInterruptsForTaskRun();
                try {
                    Object var9_5;
                    this.beforeExecute(w.thread, task);
                    Throwable thrown = null;
                    try {
                        try {
                            task.run();
                        }
                        catch (RuntimeException x) {
                            thrown = x;
                            throw x;
                        }
                        catch (Error x) {
                            thrown = x;
                            throw x;
                        }
                        catch (Throwable x) {
                            thrown = x;
                            throw new Error(x.getMessage());
                        }
                        var9_5 = null;
                        this.afterExecute(task, thrown);
                    }
                    catch (Throwable throwable) {
                        var9_5 = null;
                        this.afterExecute(task, thrown);
                        throw throwable;
                    }
                    var11_6 = null;
                    task = null;
                    ++w.completedTasks;
                }
                catch (Throwable throwable) {
                    var11_6 = null;
                    task = null;
                    ++w.completedTasks;
                    w.unlock();
                    throw throwable;
                }
                w.unlock();
                {
                }
            }
            completedAbruptly = false;
            Object var13_12 = null;
            this.processWorkerExit(w, completedAbruptly);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.processWorkerExit(w, completedAbruptly);
            throw throwable;
        }
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        int c = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(c) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(c) && this.workQueue.offer(command)) {
            int recheck = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(recheck) && this.remove(command)) {
                this.reject(command);
            } else if (ThreadPoolExecutor.workerCountOf(recheck) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(command, false)) {
            this.reject(command);
        }
    }

    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
            Object var3_2 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mainLock.unlock();
            throw throwable;
        }
        this.tryTerminate();
    }

    public List shutdownNow() {
        List tasks;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            tasks = this.drainQueue();
            Object var4_3 = null;
            mainLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
        this.tryTerminate();
        return tasks;
    }

    public boolean isShutdown() {
        return !ThreadPoolExecutor.isRunning(this.ctl.get());
    }

    public boolean isTerminating() {
        int c = this.ctl.get();
        return !ThreadPoolExecutor.isRunning(c) && ThreadPoolExecutor.runStateLessThan(c, 0x60000000);
    }

    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        ReentrantLock mainLock;
        block6: {
            boolean bl2;
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                    boolean bl3 = true;
                    Object var12_7 = null;
                    mainLock.unlock();
                    return bl3;
                }
                while (true) {
                    if (nanos <= 0L) {
                        bl = false;
                        break block6;
                    }
                    this.termination.await(nanos, TimeUnit.NANOSECONDS);
                    if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                        bl2 = true;
                        break;
                    }
                    nanos = deadline - Utils.nanoTime();
                }
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                mainLock.unlock();
                throw throwable;
            }
            Object var12_8 = null;
            mainLock.unlock();
            return bl2;
        }
        Object var12_9 = null;
        mainLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        int delta = corePoolSize - this.corePoolSize;
        this.corePoolSize = corePoolSize;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > corePoolSize) {
            this.interruptIdleWorkers();
        } else if (delta > 0) {
            int k = Math.min(delta, this.workQueue.size());
            while (k-- > 0 && this.addWorker(null, true)) {
                if (this.workQueue.isEmpty()) break;
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (value != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = value;
            if (value) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > maximumPoolSize) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long keepAliveTime = unit.toNanos(time);
        long delta = keepAliveTime - this.keepAliveTime;
        this.keepAliveTime = keepAliveTime;
        if (delta < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        boolean removed = this.workQueue.remove(task);
        this.tryTerminate();
        return removed;
    }

    /*
     * Unable to fully structure code
     */
    public void purge() {
        block5: {
            q = this.workQueue;
            try {
                it = q.iterator();
                while (it.hasNext()) {
                    r = (Runnable)it.next();
                    if (!(r instanceof Future) || !((Future)r).isCancelled()) continue;
                    it.remove();
                }
                break block5;
            }
            catch (ConcurrentModificationException fallThrough) {
                arr = q.toArray();
                i = 0;
                ** while (i < arr.length)
            }
lbl-1000:
            // 1 sources

            {
                r = arr[i];
                if (r instanceof Future && ((Future)r).isCancelled()) {
                    q.remove(r);
                }
                ++i;
                continue;
            }
        }
        this.tryTerminate();
    }

    public int getPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            Object var4_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                if (!w.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            mainLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var4_3 = null;
            mainLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
                if (!w.isLocked()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            Object var8_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
            }
            long l = n;
            Object var8_6 = null;
            mainLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            mainLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private final class Worker
    extends ReentrantLock
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }
    }
}

