#!/usr/bin/perl
use strict;
use warnings;
use Data::Dumper;

die "Usage: 4-create.pl <locale> <input.txt> <output.jar> <zip executable>" unless $#ARGV == 3;
my ($TARGET, $INPUT, $OUTPUT, $ZIP) = @ARGV;

die "Please create the directory \"com\"" unless -d "com";

foreach my $f (glob ("com/*")) {
	die "com/ directory is not empty. Please manually empty it (but do not remove the directory itself";
}

open IN, $INPUT or die $!;
my %ENTRIES;

my $value = '';
while (<IN>) {
	chomp;
	my $l = $_;
	$l =~ s/^\s+//;
	$l =~ s/\s+$//;
	next if $l eq '';
	next if $l =~ /^#/;

	my $key = $l;
	if ($key =~ /^(.*?)=(.*)$/) {
		($key, $value) = ($1,$2);
	}
	my ($dir, $file, $entry);
	if ($key =~ /^(.*?)#(.*)$/) {
		($dir, $entry) = ($1,$2);
	} else {
		print "INVALID LINE: $l\n";
		exit 1;
	}
	if ($dir =~ /^(.*)\.([^\.]+)$/) {
		($dir, $file) = ($1,$2);
		$dir = "com.amazon.$dir";
		$file = "${file}_${TARGET}.properties";
	} else {
		print "INVALID LINE: $l\n";
		exit 1;
	}
	$ENTRIES{"$dir $file"}->{$entry} = $value;
}
close IN;

foreach my $spec (keys %ENTRIES) {
	my ($dir, $file) = split(" ", $spec);
	$dir =~ s|\.|/|g;
	&ensureDirExists($dir);
	open OUT, ">$dir/$file" or die $!;
	foreach my $key (sort keys %{$ENTRIES{$spec}}) {
		print OUT "$key=";
		print OUT $ENTRIES{$spec}->{$key}."\n";
	}
	close OUT;
}

unlink $OUTPUT if -f $OUTPUT;
system("$ZIP -r -9 $OUTPUT com");

exit;

sub ensureDirExists {
	my ($dir) = @_; 
	my @parts = split(/\//, $dir);
	for my $i (1 .. $#parts) {
		my @part;
		foreach my $j (0..$i) {
			push @part, $parts[$j];
		}
		my $check = join("/",@part);
		mkdir $check unless -d $check;
	}
}
