#!/usr/bin/perl

use strict;
use warnings;
use Data::Dumper;

my $JAD = "/usr/local/bin/jad";

# ONLY CHANGE ANYTHING BELOW IF YOU KNOW WHAT YOU ARE DOING!!!
# later parts of the toolchain expect a specific format. You may
# break these expectations by changing the values below.

die ("Usage: 2-extract.pl <bundles.txt> <jars directory>") unless $#ARGV == 1 ;
my ($BUNDLES_TXT, $JARS) = @ARGV;

my $TARGET = ""; #de_DE";

# do not separate different IDs by empty lines
my $NO_SPACE = 1;

# do not display the default locale as a hinting comment. Implies $NO_OTHERS.
my $NO_TEMPLATE = 0;

# do not display unrelated locales as a hinting comment. Avoids clutter.
my $NO_OTHERS = 0;

# do not add a comment on where the translations came from. Avoids clutter.
my $NO_SOURCE = 1;

# omit warnings about MessageFormat
my $NO_WARN = 1;


open BUNDLES, $BUNDLES_TXT or die $!;
my %IMPLS;
my %TEXT;
while (<BUNDLES>) {
	chomp;
	my ($bundle, $rest) = split(/: /, $_);
	# special case
	next if $bundle =~ /ResourcesDNT$/;
	my @impls = &splitImplementations($bundle,$rest);
	$IMPLS{$bundle} = \@impls;
}
close BUNDLES;

foreach my $bundle (sort keys %IMPLS) {
	#print "Bundle: $bundle\n";
	foreach my $impls ($IMPLS{$bundle}) {
		foreach my $impl (@$impls) {
			system("rm -rf tmp/*");
			system("unzip -qq -d tmp $JARS/".$impl->{jar}." ".$impl->{file});
			my %mapping = &parseFile($impl->{type}, "tmp/".$impl->{file});
			my $locale = $impl->{locale};
			$TEXT{$bundle}->{SOURCES} .= " ".$impl->{jar}."!".$impl->{file};
			$locale =~ s/^_//;
			foreach my $key (keys %mapping) {
				$TEXT{$bundle}->{$key}->{$locale} = $mapping{$key};
			}
		}
	}
}

# prune entries
foreach my $bundle (keys %TEXT) {
	foreach my $key (sort keys %{$TEXT{$bundle}}) {
		# special key: do not translate.
		if ($key =~ /\.dnt$/) {
			delete $TEXT{$bundle}->{$key};
		}
	}
	if (scalar (keys %{$TEXT{$bundle}}) <=1 ) {
		delete $TEXT{$bundle};
	}
}

foreach my $bundle (sort keys %TEXT) {
	my $src ="###$bundle sources:". $TEXT{$bundle}->{SOURCES};
	print "$src" unless $NO_SOURCE;
	foreach my $key (sort keys %{$TEXT{$bundle}}) {
		next if $key eq 'SOURCES' or $key !~ /^\w/;
		print "\n" unless $NO_SPACE;
		my $modifiable = '';
		my $warn = '';
		foreach my $locale (sort keys %{$TEXT{$bundle}->{$key}}) {
			if ($TEXT{$bundle}->{$key}->{$locale} =~ /^!!!/) {
				if ($warn eq '' and !$NO_WARN) {
					$warn = "## WARNING: At least one of the translations initially referred directly to the MessageFormat class. Please double-check the outcome of this translation!";
					print "$warn\n";
				}
				$TEXT{$bundle}->{$key}->{$locale} =~ s|^!!!||;
			}
		}
		foreach my $locale (sort keys %{$TEXT{$bundle}->{$key}}) {
			my $out = "$bundle#$key=" . $TEXT{$bundle}->{$key}->{$locale};
			$out =~ s|^com.amazon.||;
			if ($TARGET =~ /^$locale/) {
				$modifiable = $out;
			}
			if ($locale eq '') {
				print "$out\n";
			} else {
#				$out =~ s/^.*?=//;
				$out = "\@$locale\@$out";
				print "$out\n";
			}
		}
		#print "$modifiable\n" unless $modifiable eq '';
	}
	print "\n" unless $NO_SPACE;
}
#print Dumper \%TEXT;

exit;

sub splitImplementations {
	my ($bundle, $specs) = @_;
	my $prefix = $bundle;
	$prefix =~ s|\.|/|g;
	my @impls;
	foreach my $spec (split(/\s+/, $specs)) {
		my ($jar, $file) = split(/!/, $spec);
		my $type = $file; $type =~ s/^.*\.(.*?)$/$1/;
		my $locale = $file; $locale =~ s/^$prefix//; $locale =~ s|\.$type$||;
		unless ($locale eq '' or $locale =~ /^_/) {
			print STDERR "skipping suspicious locale $locale\n";
			next;
		}
		my $impl = {locale => $locale, jar => $jar, type => $type, file => $file};
		push @impls, $impl;
	}
	return sort {$a->{'locale'} cmp $b->{'locale'} } @impls;
}

sub parseFile {
	my ($class, $file) = @_;
	my %result;
	if ($class eq 'class') {
		%result = &parseClassFile($file);
	} elsif ($class eq 'properties') {
		%result = &parseProperties($file);
	} else {
		print STDERR "Don't know how to parse file $file of type $class!\n";
	}
	return %result;
}

sub parseProperties {
	my ($file) = @_;
	my %p;
	# special case
	return %p if ($file =~ /ebook.util.resources.MccCodeMappings/);
	open PROPS, $file or die $!;
	while (<PROPS>) {
		chomp;
		my $l = $_;
		next if $l =~ /^\s*#/;
		next if $l =~ /^\s*$/;
		my ($key, $value) = split(/\s*=\s*/, $l);
		$p{$key}=$value;
	}
	close PROPS;
	return %p;
}

sub parseClassFile {
	my ($class) = @_;
	my %p;
	
	my $jad = $class;
	$jad =~ s/.class$/.jad/;
	system("$JAD -r -d tmp $class >/dev/null 2>&1");
	open JAD, $jad or die $!;
	my $state = 0;
	while (<JAD>) {
		my $l = $_;
#		print $l;
		chomp $l;
		if ($state == 0) {
			if ($l =~ /extends ((\S*)ResourceBundle|(\S*)Resources)/) {
				$state = 1;
				print STDERR "$jad now in state $state\n";
				next;
			}
		}
		elsif ($state == 1) {
			if ($l =~ /Object\s*\S*\s*(\[\])+\s*(=\s*?)\{/) {
				$state = 2;
				print STDERR "$jad now in state $state\n";
				next;
			}
		} elsif ($state == 2) {
			if ($l =~ /Object\s*\S*\s*(\[\])+\s*\{/) {
				next;
			}
			$l =~ s/^\s*//;
			$l =~ s/\s*$//;
			next if $l =~ /^([\{\},\s])+$/;
			print STDERR "POSSIBLY: $l\n";
			if ($l =~ /^"(.*?)"\s*,\s*(.*)\s*$/) {
				my ($key, $value) = ($1,$2);
#				print STDERR "PROBABLY: $key => $value\n";
				$value = &parseValue($value, $class);
				$p{$key} = $value if defined $value;
			} else {
				print STDERR "SUSPICIOUS $jad: $l\n";
			}
#			$state = 1;
			next;
		}
	}
	close JAD;
	if ($state == 0) {
		print "COULDN'T MAKE SENSE OF $jad. This is probably a bug.\n";
		exit;
	}
	return %p;
}

sub parseValue {
	my ($v, $class) = @_;
	if ($v =~ /^"(.*)"$/) {
		return $1;
	}
	elsif ($v =~ /new\s+MessageFormat\("(.*?)"\)\)/) {
		return "!!!".$1;
	}
	print STDERR "COULD NOT MAKE SENSE OF: $class $v\n";
	return undef;
}

