#!/usr/bin/perl

use strict;
use warnings;
use Data::Dumper;


########### READ THE COMMENTS BELOW!!!! #############

# This file is an attempt to make it possible to re-use localization files
# from http://code.google.com/p/k3-loc/source/checkout .
#
# It is unsupported, experimental, and whatever other tag of "not production quality"
# you want to put at it. It works on my machine, but it may not work on yours.
# You will most certainly have to adjust values in this file. You will have to
# post-process output. Well, I hope that you got the message.


my $K3LOCDIR = "/tmp/loc/k3-loc";

# YOU must take care of zipping up the output into that jar file.
my $PRODUCED_JAR = "k3loc.jar";


my %SPECS;

system("rm -rf tmp/*");

$K3LOCDIR .= "/" unless $K3LOCDIR =~ /\/$/;
foreach my $loc (glob("$K3LOCDIR*")) {
	$loc =~ s/^$K3LOCDIR//;
	if ($loc =~ /^loc_(.*)/) {
		$loc = $1;
	} else {
		next;
	}
	my $locale = $loc;
	# glitch: Ukraine locale name
	$locale = "uk" if $loc eq 'ukr';
	&convertLocale($locale, "${K3LOCDIR}loc_$loc");
}

my %FILES;
foreach my $location (sort keys %SPECS) {
	foreach my $tag (sort keys %{$SPECS{$location}}) {
		foreach my $locale (sort keys %{$SPECS{$location}->{$tag}}) {
			my $value = undef;
			if ($locale ne '') {
				$value = $SPECS{$location}->{$tag}->{$locale};
			} else {
				# oddly, there is conflicting information for the source values, most
				# probably caused by mistakes on the translators' side. We'll take the
				# value that is there in most locales, assuming that the mistakes are
				# made by a minority.

				my $max = 0;
				#yes, this is an inefficient way, but a useful one for debugging.

				foreach my $alt (keys %{$SPECS{$location}->{$tag}->{''}}) {
					my $c = $SPECS{$location}->{$tag}->{''}->{$alt};
					$max = $c if ($c > $max);
				}
				foreach my $alt (sort keys %{$SPECS{$location}->{$tag}->{''}}) {
					my $c = $SPECS{$location}->{$tag}->{''}->{$alt};
					next if $c < $max;
					if (defined $value) {
						print STDERR "Competing definitions for $location#$tag , now using: $alt\n";
					}
					$value = $alt;
				}
			}
			my $filename = $location;
			if ($locale ne '') {
				$filename .="_$locale";
			}
			$filename .= ".properties";
			$FILES{$filename}->{$tag}= $value;
		}
	}
}

foreach my $file (sort keys %FILES) {
	&prepareFor($file);
	open OUT, ">tmp/$file" or die $!;
	foreach my $tag (sort keys %{$FILES{$file}}) {
		print OUT "$tag=";
		print OUT $FILES{$file}->{$tag}."\n";
	}
	close OUT;
}

# create a bundle compatible with the expectations
open FIND, "find tmp/ -type f|";
my %MOCKS;
while (<FIND>) {
	chomp;
	my $l = $_;
	$l =~ s|tmp/||;
	my $f = $l;
	my $s = $f;
	$s =~ s/\..*$//;
	$s =~ s/_(.*?)$//;
	$s =~ s|/|.|g;
	$MOCKS{$s} .= " $PRODUCED_JAR!$f";
}
foreach my $k (sort keys %MOCKS) {
	print "$k:".$MOCKS{$k}."\n";
}
exit;

sub convertLocale {
	my ($loc, $dir) = @_;
	open FIND, "find $dir -name \"*.translation\"|grep -v .svn|" or die $!;
	while (<FIND>) {
		my $file = $_;
		chomp $file;
		my $spec = $file;
		$spec =~ s|^$dir/strings/||;
		my $ext;
		if ($spec =~ /^(.*?)\.(.*)$/) {
			($spec, $ext) = ($1, $2);
		}
		# "de-localize"
		if ($spec =~ /^(.*)_([^\/]+)$/) {
			#print "$spec => ";
			$spec = $1;
			#print "$spec\n";
		}
		if ($ext eq 'properties.translation') {
			&copyProperties($file, $spec, $loc);
		} elsif ($ext eq 'translation') {
			&parseTranslation($file, $spec, $loc);
		} else {
			die "Can't make sense of filename $file\n";
		}
	}
	close FIND;
}

sub copyProperties {
	my ($from, $spec, $loc) = @_;
	my $to ="${spec}_${loc}.properties";
	&prepareFor($to);
	system("cp $from tmp/$to");
}

sub parseTranslation {
	my ($from, $spec, $locale) = @_;
	open IN, $from or die $!;
	my $id = '';
	while (<IN>) {
		my $l = $_;
		$l =~ s/([\r\n]+)$//;
		if ($l =~ /^(.*?)\t(.*)$/) {
			my ($en, $loc) = ($1,$2);
			if (defined ($SPECS{$spec}->{$id}->{''})) {
				$SPECS{$spec}->{$id}->{''}->{$en} += 1;
#				if ($SPECS{$spec}->{$id}->{''} ne $en) {
#					print STDERR "CONFLICT FOR $spec, key $id:\n";
#					print STDERR "current value  : ".$SPECS{$spec}->{$id}->{''}."\n";
#					print STDERR "overriding with: $en\n";
#				} else {
#					#print STDERR "MATCH for $spec, key $id\n";
#				}
			} else {
				$SPECS{$spec}->{$id}->{''}->{$en} = 1;
			}
#			$SPECS{$spec}->{$id}->{''} = $en;
			$SPECS{$spec}->{$id}->{$locale} = $loc;
#			print "$spec $id ### $en -> $loc\n";
		} else {
			$id = $l if ($l =~ /\./ or $l =~ /^[a-zA-Z0-9]+$/);
		}
	}
	close IN;
#	exit;
}

sub prepareFor {
	my ($file) = @_;
#	print "preparing for $file\n";
	my $dir = $file;
	$dir = "tmp/$dir";
	$dir =~ s|/([^/]+)$||;
	system("mkdir -p $dir");
}

