#!/usr/bin/perl

use strict;
use warnings;
use Data::Dumper;

die "usage: 3-join.pl <locale> primary [secondary1 secondary2....]" unless $#ARGV >= 1;
my ($TARGET, $PRIMARY, @SECONDARIES) = @ARGV;
print STDERR "translating to $TARGET from $PRIMARY [".join(", ", @SECONDARIES)."]\n";

my %M;
&parse($PRIMARY);
foreach my $sec (@SECONDARIES) {
	&parse($sec);
}

foreach my $key (sort keys %{$M{$PRIMARY}}) {
	my ($to, $from) = ($PRIMARY, $PRIMARY);
	&findAliases($key, $to, $from);
}


#print Dumper \%M; exit;
print << 'EOT';
##########################################################################
#                 ON THE FORMAT OF THIS FILE                             #
##########################################################################
#                                                                        #
# This file serves as input for a one-stop translation.                  #
# The format is, in principle, that of a Java .properties file.          #
# In order to minimize effort, a few idiosyncrasies exist:               #
# - properties are "fully qualified", i.e., prefixed by their complete   #
#   Java "path". Ultimately, the actual locale files are generated       #
#   from this file, by splitting it into the appropriate files.          #
# - some properties share the same original string. In this case,        #
#   it is sufficient to define it only once. Any properties which        #
#   DO NOT provide a value (don't have a "=" inside) will take the       #
#   last value that was defined. Look a few lines down, you will         #
#   see an example with the "Done" string present in multiple files.     #
#                                                                        #
# You may find that some properties are preceded by one or more comment  #
# lines. These indicate that *possible* translations have been found,    #
# and where they originate from. If the suggestion makes sense, simply   #
# copy/paste it.                                                         #
##########################################################################


EOT

foreach my $key (sort keys %{$M{$PRIMARY}}) {
	# special cases:
	next if ($key =~ /^ebook.util.resources.LcidMappings#/);
	next if ($key =~ /^kindle.settings.resources.DiagnosticResources#/);
	next if ($key =~ /^ebook.util.resources.TimeZoneMappings#/);


	my $org = $M{$PRIMARY}->{$key}->{''};
	next unless defined $org;
	next if defined $M{$PRIMARY}->{$key}->{"###_IS_ALIAS_###"};
	# artifacts from parsing arrays in resource bundle classes. Fortunately not many, and not important.
	next if $org =~ /", "/;

	my %loc;
	if ($org ne '') {
		foreach my $sec (($PRIMARY, sort @SECONDARIES)) {
			foreach my $k2 (sort keys %{$M{$sec}}) {
				next unless defined $M{$sec}->{$k2}->{''};
				next unless $M{$sec}->{$k2}->{''} eq $org;
				foreach my $l2 (sort keys %{$M{$sec}->{$k2}}) {
					next if $l2 eq '';
					next unless $TARGET =~ /^$l2/;
					my $tr = $M{$sec}->{$k2}->{$l2};
					$loc{$tr} .= " $sec!$k2\@$l2";
				}
			}
		}
	}
	
	my $already = 0;	
	foreach my $tr (sort keys %loc) {
		$already = 1 if ($loc{$tr} =~ / $PRIMARY!$key/);
		print "###".$loc{$tr}."\n";
		print "#$tr\n";
	}
	#print "#$key=".$org."\n";
	if ($already) {
		print "### Commented out because already localized:\n#";
	}
	print "$key=".$org."\n";
	if (defined $M{$PRIMARY}->{$key}->{'###_ALIASES_###'}) {
		print join("\n", @{$M{$PRIMARY}->{$key}->{'###_ALIASES_###'}});
		print "\n";
	}
	print "\n";
}

#print Dumper \%M;
exit;

sub parse {
	my ($f) = @_;
	open IN, $f or die $!;
	while (<IN>) {
		my $l = $_;
		$l =~ s/\r?\n$//;
		my ($key, $value) = split(/=/, $l);
		my $locale = '';
		if ($key =~ /^\@(.*?)\@(.*)/) {
			($locale, $key) = ($1, $2);
		}
		$M{$f}->{$key}->{$locale} = $value;
	}
	close IN;
}

sub findAliases {
	my ($key, $to, $from) = @_;
	foreach my $alias (sort keys %{$M{$from}}) {
		next if (($key cmp $alias) >= 0);

		next unless defined $M{$from}->{$key}->{''};
		next unless defined $M{$to}->{$alias}->{''};

		next if $M{$from}->{$key}->{''} eq '';
		if ($M{$from}->{$key}->{''} eq $M{$from}->{$alias}->{''}){
			next if $M{$to}->{$alias}->{"###_IS_ALIAS_###"};

			print STDERR "$alias might be an alias for $key\n";
			push @{$M{$from}->{$key}->{"###_ALIASES_###"}}, $alias;
			$M{$to}->{$alias}->{"###_IS_ALIAS_###"} = 1;
		}
		
	}
}
