#!/usr/bin/perl
use strict;
use warnings;

my $JAD = "/usr/local/bin/jad";
my %BUNDLES;

die ("Usage: 1-extract.pl <bundles.txt> <jars directory>") unless $#ARGV == 1 ;
my ($BUNDLES_TXT, $JARS) = @ARGV;


# round 1: find (possible) bundles
foreach my $jar (sort glob("$JARS/*.jar")) {
	system("rm -rf tmp/*");
	system("unzip -qq -d tmp/ $jar");

	my $break = 0;
	open CLASSES, "find tmp -name '*.class'|" or die $!;
	while (<CLASSES>) {
		chomp;
		next unless /^tmp\/com\/amazon/;
		next if /\$/; # skip inner classes
		my $class = $_;
		system("$JAD -r -d tmp $class >/dev/null");
		my $jad = $class;
		$jad =~ s/.class$/.jad/;
		$break += &findBundles($jad); 
	}
	close CLASSES;
#	last if $break; #debug only
}

#round 2: verify the resources
foreach my $jar (sort glob("$JARS/*.jar")) {
	open INFO, "zipinfo $jar|" or die $!;
	$jar =~ s|^$JARS/||;
	while (<INFO>) {
		chomp;
		my $l = $_;
		$l =~ s/^.*\s//; # keep only last part, the file name
		next unless $l =~ /\.(class|properties)/;
		next if $l =~ /\$/; # inner class
		foreach my $b (keys %BUNDLES) {
			if ($l =~ /^$b/) {
				print "$b may be implemented by $l in $jar\n";
				$BUNDLES{$b} .= " $jar!$l";
			}
		}
	}
	close INFO;
}

open OUT, ">$BUNDLES_TXT" or die $!;
foreach my $k (sort keys %BUNDLES) {
	my $b = $k;
	$b =~ s|/|.|g;
	print OUT "$b:".$BUNDLES{$k}."\n";
}
close OUT;

exit;

sub findBundles {
	my ($jad) = @_;
	my $found = 0;
	return 0 unless -f $jad;
	open JAD, $jad or die "$jad ".$!;
	while (<JAD>) {
		chomp;
		my $l = $_;
		if ($l =~ /ResourceBundle/) {
			if ($l =~ /"(com\.amazon\..*?)"/) {
				my $dotted = $1;
				my $slashed = $dotted;
				$slashed =~ s|\.|/|g;
				unless (defined $BUNDLES{$slashed}) {
					print "Possible resource bundle: $dotted\n";
					$BUNDLES{$slashed} = "";
					++$found;
					unless ($dotted =~ /Resources$/) {
						print "$l\n";
					}
				}
			}
		}
	}
	close JAD;
	return $found;
}

