#!/bin/sh

mntroot rw

# Based on version 0.01 (20090724) ebs
V="0.02.N"

# Default timeout in seconds
TIMEOUT=2700

# Log somewhere out of the way
mkdir /mnt/us/sstimeout
L=/mnt/us/sstimeout/screensaver-timeout_install.log

# Result codes
OK=0
ERR=1

echo >> ${L}
echo "install: screensaver-timeout v${V}, $(date)" >> ${L}

# Give user a way to override timeout
U=/mnt/us/screensaver-timeout
if [ -f ${U} ] ; then
T=$(head -n 1 ${U} | sed 's/[^0-9]//g')
if [ "${T}" -gt 59 ] ; then
echo "Using user specified timeout ${T} from ${U}" >> ${L}
TIMEOUT=${T}
fi
fi

# FW 3.X
# if [ -f /etc/kdb/system/daemon/powerd/t1_timeout ] ; then
# F=/etc/kdb/system/daemon/powerd/t1_timeout

# FW 3.3
if [ -f /etc/kdb.src/luigi/system/daemon/powerd/t1_timeout ] ; then
F=/etc/kdb.src/luigi/system/daemon/powerd/t1_timeout

# Make a backup just in case
[ -f /mnt/us/sstimeout/t1_timeout ] || cp -p ${F} /mnt/us/sstimeout/t1_timeout 2>> ${L} || exit ${ERR}

OT=$(tail -n 1 ${F})

if [ -n "${OT}" ] ; then
if [ "${OT}" != "${TIMEOUT}" ] ; then
echo "Replacing sleep timeout (${OT} -> ${TIMEOUT})" >> ${L}
(echo -en "RG002\n40\n<DATA>\n${TIMEOUT}" > ${F}) 2>> ${L} || exit ${ERR}
else
echo "Timeout is already set to ${TIMEOUT}, skipping..." >> ${L}
fi
else
echo "Couldn't find current timeout, aborting" >> ${L}
exit ${ERR}
fi
else
# FW 2.X
F=/etc/powerd.conf

# Make a backup just in case
[ -f /mnt/us/sstimeout/powerd.conf ] || cp -p ${F} /mnt/us/sstimeout/powerd.conf 2>> ${L} || exit ${ERR}

K="t1_timeout:"
OT=$(grep "^${K}" ${F} | cut -b 13-)
if [ -n "${OT}" ] ; then
if [ "${OT}" != "${TIMEOUT}" ] ; then
echo "Replacing sleep timeout (${OT} -> ${TIMEOUT})" >> ${L}
sed -i -e "s/^\(${K}\).*$/\1 ${TIMEOUT}/" ${F} 2>> ${L} || exit ${ERR}
else
echo "Timeout is already set to ${TIMEOUT}, skipping..." >> ${L}
fi
else
echo "Addding sleep timeout (${TIMEOUT})" >> ${L}
(echo "${K} ${TIMEOUT}" >> ${F}) 2>> ${L} || exit ${ERR}
fi
fi

echo "Done!" >> ${L}
/etc/init.d/powerd restart

mntroot ro

exit ${OK}
