// scroll.c - simple framebuffer scroller for kindle with (partially)
//            broken eink display
//
// usage:
//    scroll [percent] [type]
//
// percent: optional percent of display height to scroll (0 to 100, default = 10).
// type : optional display update type (value 0 to 2, default = 1):
//    0 = no flash (fast, but slight ghosting)
//    1 = quality (full flash update, cleanest display)
//    2 = speed (very fast, black and white only)
//
// *** Disclaimers and whatnot:
//
// This is just a simple quick-and-dirty hack.
// It could use some error checking, and more features.
//
// There is no "secret sauce" here (such as intellectual "Property",
// whatever that is), nothing to protect, no license needed.
//
// As always, please do not sue me if you poke your eye out with
// this code, or somehow manage to injure your brain or otherwise
// maim yourself, your stuff, or your loved ones with it.
//
// Enjoy, compliments of geekmaster...
//
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <linux/fb.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#define FB_UPDATE_AREA 0x46dd

int main(int argc, char** argv) {
    int pct = 10;
    int fx = 1; // full flash update
    int y, height, width, width_bytes, fb_bytes;
    struct fb_var_screeninfo screeninfo;
    unsigned char *pfb = NULL, *psave = NULL;
    struct update_area_t
    {
        int x1, y1, x2, y2, fx;
        __u8 *buffer;
    } ua;

    // get optional command-line params
    if (argc > 1) pct = atoi(argv[1]);  // scroll percent (0-100)
    if (argc > 2) fx = atoi(argv[2]);   // update type (0-2)

    // open framebuffer and get screen size (assume 4 bpp)
    int fdFB = open("/dev/fb0", O_RDWR);
    ioctl(fdFB, FBIOGET_VSCREENINFO, &screeninfo);
    height = screeninfo.yres;
    width = screeninfo.xres;
    width_bytes = width / 2;
    fb_bytes = height * width_bytes;

    // map and copy framebuffer
    pfb = (unsigned char*)mmap(0, fb_bytes, PROT_READ|PROT_WRITE,
        MAP_SHARED, fdFB, 0);
    psave = malloc(fb_bytes);
    memcpy(psave, pfb, fb_bytes);

    // copy swapped slices back to framebuffer
    y = height * pct / 100;
    memcpy(pfb + y * width_bytes, psave, (height - y) * width_bytes);
    memcpy(pfb, psave + (height - y) * width_bytes, y * width_bytes);

    // trigger framebuffer update
    ua.x1 = 0;
    ua.y1 = 0;
    ua.x2 = width;
    ua.y2 = height;
    ua.fx = fx;  // update type
    ioctl(fdFB, FB_UPDATE_AREA, &ua);

    // cleanup
    free (psave);
    munmap(pfb, fb_bytes);
    close(fdFB);
}
