#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_mackxpatch
INSTALLERDIR=/media/mmcblk0p1/Programs/Install
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity
MTAG=/media/mmcblk0p1/Programs/_mackxpatch/bin/mtag

cd $THISDIR

$ZENITY --question --title "MackxPatch Alternatives" --text "<b>Add Alternatives</b>\n\nDo you want to install pdfviewer as alternative for PDF?"
if [ $? -eq 0 ]; then
    # Adapt gconf to enable the new views
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

    # PdfViewer Alternative
    /bin/cp -f ./schemas/alt-pdfviewer.schemas /etc/gconf/schemas/alt-pdfviewer.schemas
    gconftool-2 --makefile-install-rule /etc/gconf/schemas/alt-pdfviewer.schemas

    # Create Backup of dr.ini
    /bin/cp -f /media/mmcblk0p1/System/dr.ini /media/mmcblk0p1/System/dr.patch.ini
    # and save the (just modified) settings to disk
    /usr/bin/erconftool -e /apps/er

    # For the new version to be used, a reset is needed
    $ZENITY --info --title "MackxPatch Alternatives" --text "<b>Alternatives Installed</b>\n\nPress ok to reboot"
    /sbin/reboot
    sleep 31
fi