#!/bin/sh

#
# $Id: install.sh 6845 2010-09-23 23:11:24Z NiLuJe $
#
# diff OTA patch script

# Hack specific config (name and when to start/stop)
HACKNAME="freedownload"
BACKUP_DIR="/opt/backup/$HACKNAME"
HACK_HOME="/mnt/us/$HACKNAME"
LOG_FILE="$HACK_HOME/install.log"
WRS_INI="/opt/amazon/ebook/config/wrs.ini"
BIN_DIR="/usr/local/bin"

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    if [ "$_MSG_LEVEL" != "D" ]; then
      echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
      [ -d /mnt/us/$HACKNAME ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT" >> $LOG_FILE
    fi
}

#Create hack home dir at user store
[ -d "$HACK_HOME" ] || mkdir -p "$HACK_HOME"

update_progressbar 10

# Revert changes made by previous versions

logmsg "I" "update" "revert changes made by previous buggy versions"
/etc/init.d/browserd stop || true
[ -f "$BACKUP_DIR/browserd" ] && mv -f "$BACKUP_DIR/browserd" /etc/init.d/browserd
#[ -f "$BACKUP_DIR/wrs.ini" ] && mv -f "$BACKUP_DIR/wrs.ini" "$WRS_INI"
#[ -d "$BACKUP_DIR" ] && rm -Rf "$BACKUP_DIR"

update_progressbar 20

#Remove hack script from home dir at user store
logmsg "I" "update" "remove hack script from home dir"
[ -f "$HACK_HOME/freedownload" ] && rm -f "$HACK_HOME/freedownload"

# Backup original files
logmsg "I" "update" "backup original files"
[ -d "$BACKUP_DIR" ] || mkdir -p "$BACKUP_DIR"

update_progressbar 30

if [ -f "$BACKUP_DIR/wrs.ini" ]
then
    logmsg "I" "update" "wrs.ini backup already present"
else
    cp -a "$WRS_INI" "$BACKUP_DIR/" || return 2
fi

update_progressbar 40
logmsg "I" "update" "copy the readme"
cp -f "README" "$HACK_HOME/"

update_progressbar 50
logmsg "I" "update" "copy the config file"
[ -f "$HACK_HOME/$HACKNAME.conf" ] && cp -f "$HACKNAME.conf" "$HACK_HOME/$HACKNAME.conf.new"
[ -f "$HACK_HOME/$HACKNAME.conf" ] || cp -f "$HACKNAME.conf" "$HACK_HOME/"

update_progressbar 60
logmsg "I" "update" "copy the main script"
cp -f "$HACKNAME" "$BIN_DIR/" || return 3
chmod a+x "$BIN_DIR/$HACKNAME"

update_progressbar 70
logmsg "I" "update" "copy freedownloadd init script"
# kills also this script [ ! -x /etc/init.d/freedownloadd ] || /etc/init.d/freedownloadd stop || true
cp -f freedownloadd /etc/init.d/ || return 4
chmod a+x /etc/init.d/freedownloadd
# Make rc symlinks
for RC in 0 1 2 3 4 6
do
    ln -sf /etc/init.d/freedownloadd /etc/rc$RC.d/K07freedownloadd || return 5
done
ln -sf /etc/init.d/freedownloadd /etc/rc5.d/S93freedownloadd || return 6

update_progressbar 80
logmsg "I" "update" "modify wrs.ini"
grep -q '^debugFlags\b' "$WRS_INI" || echo 'debugFlags = "resources"' >> "$WRS_INI"
grep -q '^debugFile\b' "$WRS_INI" || echo 'debugFile = "/var/local/log/browser_log"' >> "$WRS_INI"

update_progressbar 90

grep -q '^debugFlags = "resources"' "$WRS_INI" || return 7
grep -q '^debugFile = "/var/local/log/browser_log"' "$WRS_INI" || return 8
logmsg "I" "update" "done"
update_progressbar 100

return 0
