#!/bin/sh
#
# $Id: install.sh 6845 2010-09-23 23:11:24Z NiLuJe $
#
# diff OTA patch script

# Hack specific config (name and when to start/stop)
HACKNAME="freedownload"
BACKUP_DIR="/opt/backup/$HACKNAME"
HACK_HOME="/mnt/us/$HACKNAME"
LOG_FILE="$HACK_HOME/install.log"
WRS_INI="/opt/amazon/ebook/config/wrs.ini"
BIN_DIR="/usr/local/bin"

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    if [ "$_MSG_LEVEL" != "D" ]; then
      echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
      [ -d /mnt/us/$HACKNAME ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT" >> $LOG_FILE
    fi
}

update_progressbar 20

# Restore original files
logmsg "I" "update" "restore original files"
/etc/init.d/browserd stop
[ ! -f "$BACKUP_DIR/browserd" ] || cp -f "$BACKUP_DIR/browserd" /etc/init.d/browserd || return 1
chmod a+x /etc/init.d/browserd
cp -f "$BACKUP_DIR/wrs.ini" "$WRS_INI" || return 2
[ -d "$BACKUP_DIR" ] && rm -Rf "$BACKUP_DIR"

update_progressbar 40

#Remove the scripts
logmsg "I" "update" "remove both scripts"
# kills also this script /etc/init.d/freedownloadd stop || true
[ -f "/etc/init.d/freedownloadd" ] && rm -f "/etc/init.d/freedownloadd"
[ -f "$BIN_DIR/freedownload" ] && rm -f "$BIN_DIR/freedownload"

# Remove rc symlinks
for RC in 0 1 2 3 4 6
do
    rm -f /etc/rc$RC.d/K07freedownloadd || true
done
rm -f /etc/rc5.d/S93freedownloadd || true

update_progressbar 60

#Remove the log fifo
logmsg "I" "update" "remove the log fifo"
rm -f /var/local/log/browser_log || true

update_progressbar 80

#Remove the pid files
rm -f "/var/local/browser/freedownload*.pid" || true

update_progressbar 90


#Remove hack home dir at user store
logmsg "I" "update" "remove hack home dir"
[ -d "$HACK_HOME" ] && rm -Rf "$HACK_HOME"

#logmsg "I" "update" "done"
update_progressbar 100

return 0
