#! /bin/sh
#

HACKNAME="freedownload"
PKGNAME="${HACKNAME}"
PKGVER="0.4"

KINDLE_MODELS="k2 k2i dx dxi dxg k3g k3w k3gb"
for model in ${KINDLE_MODELS} ; do
	# Prepare our files for this specific kindle model...
	ARCH=${PKGNAME}_${PKGVER}_${model}

	# Build install update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_install "$HACKNAME" "$HACKNAME"d "$HACKNAME.conf" install.sh README

	# Build uninstall update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_uninstall uninstall.sh
done

# Pack the updates
zip ../${PKGNAME}_${PKGVER}.zip *.bin README
rm -f *.bin
