#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Pr.BarnArt, based on the Barnes work by Grant Drake and BOL_NL'
__docformat__ = 'restructuredtext en'

from PyQt4 import QtGui
from PyQt4.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox
from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from calibre.utils.config import JSONConfig

STORE_NAME = 'Options'
KEY_MAX_DOWNLOADS = 'maxDownloads'
KEY_COVERSIZE = 'coversize'
KEY_COMMENTS_BOL_IT= 'get comments bol_it'
KEY_COVER_BOL_IT='get cover from bol_it'


DEFAULT_STORE_VALUES = {
    KEY_MAX_DOWNLOADS: 1,
	KEY_COMMENTS_BOL_IT: False,
	KEY_COVER_BOL_IT: False,
	KEY_COVERSIZE: 0
	
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/ANOBII')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):

    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox('Other options', self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 1, 2)
        other_group_box_layout = QGridLayout()
        other_group_box.setLayout(other_group_box_layout)

        max_label = QLabel('Maximum title/author search matches to evaluate (1 = fastest):', self)
        max_label.setToolTip('BOL.it do not always have links to large covers for every ISBN\EAN\n'
                             'of the same book. Increasing this value will take effect when doing\n'
                             'title/author searches to consider more ISBN editions.\n\n'
                             'This will increase the potential likelihood of getting a larger cover\n'
                             'though does not guarantee it.')
        other_group_box_layout.addWidget(max_label, 0, 0, 1, 1)
        self.max_downloads_spin = QtGui.QSpinBox(self)
        self.max_downloads_spin.setMinimum(1)
        self.max_downloads_spin.setMaximum(5)
        self.max_downloads_spin.setProperty('value', c.get(KEY_MAX_DOWNLOADS, DEFAULT_STORE_VALUES[KEY_MAX_DOWNLOADS]))
        other_group_box_layout.addWidget(self.max_downloads_spin, 0, 1, 1, 1)
        other_group_box_layout.setColumnStretch(2, 1)
		
		
		self.comments_bol_it_checkbox = QCheckBox('Get description from BOL.it if available', self)
        self.comments_bol_it_checkbox.setToolTip('The book description is taken from ANOBII by default. If you think Bol.it is more complete, you can use this option')
        self.comments_bol_it_checkbox.setChecked(c.get(KEY_COMMENTS_BOL_IT, DEFAULT_STORE_VALUES[KEY_COMMENTS_BOL_IT]))
        other_group_box_layout.addWidget(self.comments_bol_it_checkbox, 1, 0, 1, 3)
		
		self.cover_bol_it_checkbox = QCheckBox('Get cover from BOL.it if available', self)
        self.cover_bol_it_checkbox.setToolTip('The cover is taken from ANOBII by default. If you think Bol.it is better, you can use this option')
        self.cover_bol_it_checkbox.setChecked(c.get(KEY_COVER_BOL_IT, DEFAULT_STORE_VALUES[KEY_COVER_BOL_IT]))
        other_group_box_layout.addWidget(self.cover_bol_it_checkbox, 2, 0, 1, 3)
		
		cover_label = QLabel('Size of "No Cover Available" - image  from bol.it (max 1000KB)', self)
        cover_label.setToolTip('Set size in bytes, images of this size wil be rejected')
        other_group_box_layout.addWidget(cover_label, 3, 0, 1, 3)
        self.coversize_spin = QtGui.QSpinBox(self)
        self.coversize_spin.setMinimum(0)
        self.coversize_spin.setMaximum(1000000)
        self.coversize_spin.setProperty('value', c.get(KEY_COVERSIZE, DEFAULT_STORE_VALUES[KEY_COVERSIZE]))
        other_group_box_layout.addWidget(self.coversize_spin, 3, 1, 1, 1)
      
    def commit(self):
        DefaultConfigWidget.commit(self)
        new_prefs = {}
        new_prefs[KEY_MAX_DOWNLOADS] = int(unicode(self.max_downloads_spin.value()))
		new_prefs[KEY_COVERSIZE] = int(unicode(self.coversize_spin.value()))
        new_prefs[KEY_COVER_BOL_IT] = self.cover_bol_it_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_COMMENTS_BOL_IT] = self.comments_bol_it_checkbox.checkState() == Qt.Checked
        plugin_prefs[STORE_NAME] = new_prefs

