/*
 * Copyright (C) 2011 vldmr
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


/*
 *  Example program to test framebuffer on entourage edge
 *  Accepts images send from other programs and displays them on eink
 *  Based on "Send to Framebuffer" application by Sven Killig
 *  http://sven.killig.de/android/N1/2.2/usb_host
 */

package org.vldmr.edgefb;

import java.io.IOException;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore.Images.Media;
import android.util.Log;
import android.widget.TextView;

public class SendToEdgeFB extends Activity
{

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        TextView t=(TextView)findViewById(R.id.my_textview);
        Intent i=getIntent();
        t.setText("getDataString:"+i.getDataString()+"\n");
        t.append("getScheme:"+i.getScheme()+"\n");
        t.append("getType:"+i.getType()+"\n");
        t.append("getData:"+i.getData()+"\n");
        Bundle b=i.getExtras();
        String s=b.get(Intent.EXTRA_STREAM).toString();
        Log.d(this.getClass().getSimpleName(), "s="+s);
        t.append("EXTRA_STREAM:"+s+"\n");

        try {
            EdgeFB fb=new EdgeFB(2);
            t.append("fb.getWidth():"+fb.getWidth()+"\n");
            t.append("fb.getHeight():"+fb.getHeight()+"\n");
            t.append("maxMemory="+Runtime.getRuntime().maxMemory()+"\n");
            Bitmap bmf=Media.getBitmap(getContentResolver(), Uri.parse(s));

            if(bmf!=null) {
                Bitmap bm=fb.createBitmap();
                Canvas c = new Canvas(bm);
                Paint paint = new Paint();
                ColorMatrix cm = new ColorMatrix();
                cm.setSaturation(0);
                ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
                paint.setColorFilter(f);

                int width, height;
                float aspectRatioSrc=(float)bmf.getWidth()/(float)bmf.getHeight(); // 4/3=1.3
                float aspectRatioDst=(float)fb.getWidth()/(float)fb.getHeight(); // 15/9=1.6

                if(aspectRatioSrc<aspectRatioDst) {
                    height=fb.getHeight();
                    width=(int)((float)height*aspectRatioSrc);
                } else {
                    width=fb.getWidth();
                    height=(int)((float)width/aspectRatioSrc);
                }

                bmf = Bitmap.createScaledBitmap(bmf, width, height, true);

                int left=(fb.getWidth()-width)/2;
                int top=(fb.getHeight()-height)/2;
                c.drawBitmap(bmf, (Rect)null, new Rect(left, top, left+width, top+height), paint);

                bmf.recycle();
                fb.transfer(bm, true);
                finish();
            }
        } catch (IOException e) {
            e.printStackTrace();
            t.append(e.toString());
        }
    }
}
