/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.ClippingsLibrary;

import WT.Kindle.ClippingsLibrary.Book;
import WT.Kindle.ClippingsLibrary.Clipping;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    private static boolean debugON = true;
    private static boolean guiEnabled = false;

    public static String calendarToDateString(Calendar cal) {
        int intDay = cal.get(5);
        int intMonth = cal.get(2);
        int intYear = cal.get(1);
        String strDay = intDay < 10 ? "0" + intDay : "" + intDay;
        String strMonth = intMonth < 10 ? "0" + intMonth : "" + ++intMonth;
        String retVal = String.valueOf(strDay) + "/" + strMonth + "/" + intYear;
        return retVal;
    }

    public static String calendarToTimeString(Calendar cal) {
        int intHour = cal.get(11);
        int intMin = cal.get(12);
        String strHour = intHour < 10 ? "0" + intHour : "" + intHour;
        String strMin = intMin < 10 ? "0" + intMin : "" + intMin;
        String retVal = String.valueOf(strHour) + ":" + strMin;
        return retVal;
    }

    public static Clipping[] parseClippings(String input) {
        String[] clippings;
        ArrayList<Clipping> retVal = new ArrayList<Clipping>();
        String delimiter = "==========";
        input = input.substring(0, input.lastIndexOf("=========="));
        String[] stringArray = clippings = input.split("==========");
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            String clipping = stringArray[n2];
            Clipping clip = new Clipping(clipping.trim());
            retVal.add(clip);
            ++n2;
        }
        return retVal.toArray(new Clipping[0]);
    }

    public static ArrayList<Book> generateBooksList(String input) {
        return Utility.generateBooksList(new ArrayList<Book>(), input);
    }

    public static ArrayList<Book> generateBooksList(ArrayList<Book> books, String input) {
        Clipping[] clippings;
        Clipping[] clippingArray = clippings = Utility.parseClippings(input);
        int n = clippings.length;
        int n2 = 0;
        while (n2 < n) {
            Clipping clipping = clippingArray[n2];
            String clippingTitle = clipping.getTitle();
            String clippingAuthor = clipping.getAuthor();
            boolean added = false;
            for (Book book : books) {
                if (!clippingTitle.equals(book.getTitle()) || !clippingAuthor.equals(book.getAuthor())) continue;
                book.add(clipping, true);
                added = true;
            }
            if (!added) {
                Book book;
                book = new Book(clippingTitle, clippingAuthor);
                book.add(clipping);
                books.add(book);
            }
            ++n2;
        }
        return books;
    }

    public static ArrayList<Book> mergeDuplicates(ArrayList<Book> input) {
        ArrayList<Book> books = input;
        ArrayList<Book> toBeRemoved = new ArrayList<Book>();
        ArrayList<Book> toBeReAdded = new ArrayList<Book>();
        for (Book book1 : books) {
            for (Book book2 : books) {
                if (!book1.getTitle().endsWith(book2.getTitle()) || book1 == book2) continue;
                toBeRemoved.add(book1);
                toBeRemoved.add(book2);
                Book mergedBook = new Book(book1.getTitle(), book1.getAuthor());
                mergedBook.add(book1.getClippings());
                mergedBook.add(book2.getClippings());
                toBeReAdded.add(mergedBook);
            }
        }
        for (Book book : toBeRemoved) {
            books.remove(book);
        }
        for (Book book : toBeReAdded) {
            books.add(book);
        }
        return books;
    }

    public static String generateBooksHTML(String input) {
        String html = Utility.generateBooksHTML(Utility.generateBooksList(input));
        return html;
    }

    public static String generateBooksHTML(ArrayList<Book> input) {
        String html = "";
        html = String.valueOf(html) + "<html>";
        html = String.valueOf(html) + "\n<head>";
        html = String.valueOf(html) + "\n<title>Kindle Clipping Organizer Export</title>";
        html = String.valueOf(html) + "\n</head>";
        html = String.valueOf(html) + "\n<body>";
        for (Book book : input) {
            html = String.valueOf(html) + book.toHTMLstub();
            html = String.valueOf(html) + "\n<hr/>";
        }
        html = String.valueOf(html) + "\n</body>";
        html = String.valueOf(html) + "\n</html>";
        return html;
    }

    public static String generateBooksXML(String input) {
        String xml = Utility.generateBooksXML(Utility.generateBooksList(input));
        return xml;
    }

    public static String generateBooksXML(ArrayList<Book> input) {
        ArrayList<Book> books = input;
        for (Book book : books) {
            book.sortClippings();
        }
        String xml = "<?xml version=\"1.0\"?>";
        xml = String.valueOf(xml) + "\n";
        xml = String.valueOf(xml) + "<Clippings>";
        for (Book book : books) {
            xml = String.valueOf(xml) + book.toXML(1);
        }
        xml = String.valueOf(xml) + "\n";
        xml = String.valueOf(xml) + "</Clippings>";
        return xml;
    }

    public static int monthToInt(String month) {
        int retVal = 0;
        if (month.equals("January")) {
            retVal = 1;
        } else if (month.equals("Febuary")) {
            retVal = 2;
        } else if (month.equals("March")) {
            retVal = 3;
        } else if (month.equals("April")) {
            retVal = 4;
        } else if (month.equals("May")) {
            retVal = 5;
        } else if (month.equals("June")) {
            retVal = 6;
        } else if (month.equals("July")) {
            retVal = 7;
        } else if (month.equals("August")) {
            retVal = 8;
        } else if (month.equals("September")) {
            retVal = 9;
        } else if (month.equals("October")) {
            retVal = 10;
        } else if (month.equals("November")) {
            retVal = 11;
        } else if (month.equals("December")) {
            retVal = 12;
        }
        Utility.debug("Utility", "monthToInt", "month", month);
        Utility.debug("Utility", "monthToInt", "month", month.replace("\r", "~").replace("\n", "#"));
        Utility.debug("Utility", "monthToInt", "retVal", Integer.toString(retVal));
        return retVal;
    }

    public static int[] timeToInt(String time) {
        int[] retVal = new int[2];
        String[] temp1 = time.split(":");
        String[] temp2 = temp1[1].split(" ");
        retVal[0] = Integer.parseInt(temp1[0]);
        retVal[1] = Integer.parseInt(temp2[0]);
        Utility.debug("Clipping", "timeToInt", "temp2[1]", "\"" + temp2[1] + "\"");
        if (time.contains("PM") && retVal[0] != 12) {
            retVal[0] = retVal[0] + 12;
        } else if (time.contains("AM") && retVal[0] == 12) {
            retVal[0] = 0;
        }
        return retVal;
    }

    public static void debugOn(boolean debugON) {
        Utility.debugON = debugON;
    }

    public static void debug(String classs, String location, String variableName, String variable) {
        if (Utility.isDebugOn()) {
            System.out.println("Debug(" + classs + ":" + location + "): " + variableName + " = \"" + variable + "\"");
        }
    }

    public static void debug(int number, String classs, String location, String variableName, String variable) {
        if (Utility.isDebugOn()) {
            System.out.println("Debug[" + number + "](" + classs + ":" + location + "): " + variableName + " = \"" + variable + "\"");
        }
    }

    public static void debug(String classs, String location, String message) {
        if (Utility.isDebugOn()) {
            System.out.println("Debug(" + classs + ":" + location + "): " + message);
        }
    }

    public static boolean isDebugOn() {
        return debugON;
    }

    public static void setGUIEnabled(boolean val) {
        guiEnabled = val;
    }

    public static boolean getGUIEnabled() {
        return guiEnabled;
    }

    public static void error(String classs, String location, String message) {
        System.out.println("An error has occured in class " + classs + ", method " + location + "!\nInformation:\n" + message);
    }

    public static void error(String message) {
        if (guiEnabled) {
            JOptionPane.showMessageDialog(new JFrame(), message);
        } else {
            System.out.println("Error: " + message);
        }
    }

    public static String fileToString(File file) {
        byte[] buffer = new byte[(int)file.length()];
        try {
            FileInputStream f = new FileInputStream(file);
            f.read(buffer);
            f.close();
        }
        catch (IOException e) {
            Utility.error("Unable to open file");
        }
        Utility.debug("Utility", "fileToString", "buffer", new String(buffer));
        boolean startBytesStrange = false;
        int i = 0;
        while (i < 3) {
            Utility.debug("Utility", "fileToString", "buffer[" + i + "]", Byte.toString(buffer[i]));
            startBytesStrange = Byte.toString(buffer[i]).equals("-17");
            startBytesStrange = Byte.toString(buffer[i]).equals("-69");
            startBytesStrange = Byte.toString(buffer[i]).equals("-65");
            ++i;
        }
        if (startBytesStrange) {
            byte[] newByte = new byte[buffer.length - 3];
            int j = 0;
            int i2 = 3;
            while (i2 < buffer.length) {
                newByte[j] = buffer[i2];
                ++i2;
                ++j;
            }
            buffer = newByte;
        }
        String retval = new String(buffer);
        retval = "\n" + retval;
        return retval;
    }

    public static String fileToString(String filePath) {
        File file = new File(filePath);
        return Utility.fileToString(file);
    }

    public static void copyToClipboard(ClipboardOwner owner, String message) {
        StringSelection stringSelection = new StringSelection(message);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, owner);
    }
}

