/*
 * Decompiled with CFR 0.152.
 */
package WT.Kindle.ClippingsLibrary;

import WT.Kindle.ClippingsLibrary.Clipping;
import WT.Kindle.ClippingsLibrary.Utility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Book
implements Serializable {
    private static final long serialVersionUID = 1860440314462314177L;
    private String title;
    private String author;
    private ArrayList<Clipping> notes;
    private ArrayList<Clipping> highlights;
    private ArrayList<Clipping> bookmarks;
    private boolean isTitleSet;
    private boolean isAuthorSet;

    public Book() {
        this.title = "";
        this.author = "";
        this.notes = new ArrayList();
        this.highlights = new ArrayList();
        this.bookmarks = new ArrayList();
        this.isTitleSet = false;
        this.isAuthorSet = false;
    }

    public Book(String title) {
        this.title = title;
        this.author = "";
        this.notes = new ArrayList();
        this.highlights = new ArrayList();
        this.bookmarks = new ArrayList();
        this.isTitleSet = true;
        this.isAuthorSet = false;
    }

    public Book(String title, String author) {
        this.title = title;
        this.author = author;
        this.notes = new ArrayList();
        this.highlights = new ArrayList();
        this.bookmarks = new ArrayList();
        this.isTitleSet = true;
        this.isAuthorSet = true;
    }

    public boolean IsTitleSet() {
        return this.isTitleSet;
    }

    public boolean IsAuthorSet() {
        return this.isAuthorSet;
    }

    public boolean isClippingInBook(Clipping clipping) {
        boolean retval;
        block4: {
            block5: {
                block3: {
                    retval = false;
                    if (!clipping.getType().equals("Note")) break block3;
                    for (Clipping clip : this.notes) {
                        if (!clip.equals(clipping)) continue;
                        retval = true;
                    }
                    break block4;
                }
                if (!clipping.getType().equals("Highlight")) break block5;
                for (Clipping clip : this.highlights) {
                    if (!clip.equals(clipping)) continue;
                    retval = true;
                }
                break block4;
            }
            if (!clipping.getType().equals("Bookmark")) break block4;
            for (Clipping clip : this.bookmarks) {
                if (!clip.equals(clipping)) continue;
                retval = true;
            }
        }
        return retval;
    }

    public void remove(Clipping clipping) {
        block3: {
            block5: {
                block4: {
                    if (!clipping.getType().equals("Note")) break block4;
                    for (Clipping clip : this.notes) {
                        if (!clip.equals(clipping)) continue;
                        this.notes.remove(clip);
                        break block3;
                    }
                    break block3;
                }
                if (!clipping.getType().equals("Highlight")) break block5;
                for (Clipping clip : this.highlights) {
                    if (!clip.equals(clipping)) continue;
                    this.highlights.remove(clip);
                    break block3;
                }
                break block3;
            }
            if (!clipping.getType().equals("Bookmark")) break block3;
            for (Clipping clip : this.bookmarks) {
                if (!clip.equals(clipping)) continue;
                this.bookmarks.remove(clip);
                break;
            }
        }
    }

    public void add(Clipping clipping) {
        this.add(clipping, false);
    }

    public void add(Clipping clipping, boolean checkExists) {
        if (this.title.equals(clipping.getTitle())) {
            if (this.author.equals(clipping.getAuthor())) {
                if (checkExists) {
                    if (!this.isClippingInBook(clipping)) {
                        this.addClipping(clipping);
                    }
                } else {
                    this.addClipping(clipping);
                }
            } else {
                Utility.debug("Book", "add", "Clipping not added - Author does not match book's");
            }
        } else {
            Utility.debug("Book", "add", "Clipping not added - Title does not match book's");
        }
    }

    private void addClipping(Clipping clipping) {
        if (clipping.getType().equals("Note")) {
            this.notes.add(clipping);
        } else if (clipping.getType().equals("Highlight")) {
            this.highlights.add(clipping);
        } else if (clipping.getType().equals("Bookmark")) {
            this.bookmarks.add(clipping);
        }
    }

    public void add(ArrayList<Clipping> clippings) {
        for (Clipping clipping : clippings) {
            this.add(clipping);
        }
    }

    public void setTitle(String title) {
        if (!this.isTitleSet) {
            this.title = title;
            this.isTitleSet = true;
        } else {
            Utility.debug("Book", "setTitle", "Title has allready been set");
        }
    }

    public void setAuthor(String author) {
        if (!this.isTitleSet) {
            this.author = author;
            this.isAuthorSet = true;
        } else {
            Utility.debug("Book", "setTitle", "Author has allready been set");
        }
    }

    public void setClippings(ArrayList<Clipping> clippings) {
        this.notes = new ArrayList();
        this.highlights = new ArrayList();
        this.bookmarks = new ArrayList();
        this.add(clippings);
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public ArrayList<Clipping> getClippings() {
        ArrayList<Clipping> clippings = new ArrayList<Clipping>();
        clippings.addAll(this.notes);
        clippings.addAll(this.highlights);
        clippings.addAll(this.bookmarks);
        return clippings;
    }

    public ArrayList<Clipping> getNotes() {
        return this.notes;
    }

    public ArrayList<Clipping> getHighlights() {
        return this.highlights;
    }

    public ArrayList<Clipping> getBookmarks() {
        return this.bookmarks;
    }

    public String toHTML() {
        String html = "";
        html = String.valueOf(html) + "<html>";
        html = String.valueOf(html) + "\n<head>";
        html = String.valueOf(html) + "\n<title>Kindle Clipping Organizer Export</title>";
        html = String.valueOf(html) + "\n</head>";
        html = String.valueOf(html) + "\n<body>";
        html = this.toHTMLstub();
        html = String.valueOf(html) + "\n</body>";
        html = String.valueOf(html) + "\n</html>";
        return html;
    }

    public String toHTMLstub() {
        String html = "";
        html = String.valueOf(html) + "\n<div class=\"book\">";
        html = String.valueOf(html) + "\n<hr/>";
        html = String.valueOf(html) + "\nTitle: " + this.title + "<br/>";
        html = String.valueOf(html) + "\nAuthor: " + this.author + "<br/>";
        html = String.valueOf(html) + "\n<hr/>";
        for (Clipping clipping : this.getClippings()) {
            html = String.valueOf(html) + clipping.toHTML();
        }
        html = String.valueOf(html) + "\n<hr/>";
        html = String.valueOf(html) + "\n</div>";
        return html;
    }

    public String toXML(int indentation) {
        String indent = "";
        int i = 0;
        while (i < indentation) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        String xml = "";
        xml = String.valueOf(xml) + "\n" + indent + "<Book>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Title>" + this.title + "</Title>";
        xml = String.valueOf(xml) + "\n\t" + indent + "<Author>" + this.author + "</Author>";
        xml = String.valueOf(xml) + "\n\t\t" + indent + "<Notes>";
        for (Clipping clipping : this.notes) {
            xml = String.valueOf(xml) + clipping.toXML(indentation + 2);
        }
        xml = String.valueOf(xml) + "\n\t\t" + indent + "</Notes>";
        xml = String.valueOf(xml) + "\n\t\t" + indent + "<Highlights>";
        for (Clipping clipping : this.highlights) {
            xml = String.valueOf(xml) + clipping.toXML(indentation + 2);
        }
        xml = String.valueOf(xml) + "\n\t\t" + indent + "</Highlights>";
        xml = String.valueOf(xml) + "\n\t\t" + indent + "<Bookmarks>";
        for (Clipping clipping : this.bookmarks) {
            xml = String.valueOf(xml) + clipping.toXML(indentation + 2);
        }
        xml = String.valueOf(xml) + "\n\t\t" + indent + "</Bookmarks>";
        xml = String.valueOf(xml) + "\n" + indent + "</Book>";
        return xml;
    }

    public String toString() {
        int size = this.notes.size() + this.highlights.size() + this.bookmarks.size();
        String retVal = String.valueOf(this.title) + "(" + size + ")";
        return retVal;
    }

    public void sortClippings() {
        Collections.sort(this.notes);
        Collections.sort(this.bookmarks);
        Collections.sort(this.highlights);
    }
}

