#!/bin/sh                                                                       
echo "Run DK" 

SYS_LITE_PATH="/test/DKLite"
USER_LITE_PATH="/mnt/us/DK_System/Lite"
RUN_TAG="$SYS_LITE_PATH/duokantag"
APP_LITE_NOTFOND_RET="100"
APP_EBOOK_NOTFOND_RET="110"

stitch_to_lite()
{
	lipc-set-prop com.lab126.audio Kill 1
	mntroot rw
	if [ -f /etc/rc5.d/s96rundk ]
	then
			mv /etc/rc5.d/s96rundk /etc/rc5.d/S96rundk
	fi
	mv /etc/rc5.d/S95framework /etc/rc5.d/s95framework
	touch $RUN_TAG
  echo  "lite" > $RUN_TAG
  mntroot ro
  /etc/rc5.d/S96rundk
}
stitch_to_ebook()
{
	lipc-set-prop com.lab126.audio Kill 1
	mntroot rw
	if [ -f /etc/rc5.d/s96rundk ]
	then
			mv /etc/rc5.d/s96rundk /etc/rc5.d/S96rundk
	fi
	mv /etc/rc5.d/S95framework /etc/rc5.d/s95framework
	touch $RUN_TAG
  echo  "ebook" > $RUN_TAG
  mntroot ro
  /etc/rc5.d/S96rundk
}
stitch_to_kindle()
{
	lipc-set-prop com.lab126.audio Kill 1
	mntroot rw
	if [ -f mv /etc/rc5.d/S96rundk ]
	then
			mv /etc/rc5.d/S96rundk /etc/rc5.d/s96rundk
	fi
	mv /etc/rc5.d/s95framework /etc/rc5.d/S95framework
  mntroot ro
  /etc/init.d/framework stop
  /etc/init.d/framework start &
}
get_usb_state()
{
  KINDLE3PATH=`kdb get system/driver/usb/gadget/SYS_GADGET_ONLINE`
  KINDLE3USBSTAT=`cat $KINDLE3PATH`
  KINDLE2USBSTAT=`cat /sys/devices/platform/arc_udc/gadget/gadget-lun0/online`
  
  usid=$(cat /proc/usid)
  temp=$(expr substr "$usid" 1 4)
  case $temp in
  B002)
    echo Kindle 2
    return $KINDLE2USBSTAT
    ;;
  B003)
    echo Kindle 2i
    return $KINDLE2USBSTAT
    ;;
  B004)
    echo Kindle DX
    return $KINDLE2USBSTAT
    ;;
  B005)
    echo Kindle DXi
    return $KINDLE2USBSTAT
    ;;
  B009)
    echo Kindle DXG
    return $KINDLE2USBSTAT
    ;;
  B006)
    echo Kindle 3
    return $KINDLE3USBSTAT
    ;;
  B008)
    echo Kindle 3
    return $KINDLE3USBSTAT
    ;;
  B00A)
    echo Kindle 3
    return $KINDLE3USBSTAT
    ;;
  *)
    echo No id
    ;;
  esac
}
switch_otg()
{
  echo $1
  usid=$(cat /proc/usid)
  temp=$(expr substr "$usid" 1 4)
  case $temp in
  B002)
    echo Kindle 2
    echo "$1" > "/sys/devices/platform/arc_udc/gadget/gadget-lun0/file"
    ;;
  B003)
    echo Kindle 2i
    echo "$1" > "/sys/devices/platform/arc_udc/gadget/gadget-lun0/file"
    ;;
  B004)
    echo Kindle DX
    echo "$1" > "/sys/devices/platform/arc_udc/gadget/gadget-lun0/file"
    ;;
  B005)
    echo Kindle DXi
    echo "$1" > "/sys/devices/platform/arc_udc/gadget/gadget-lun0/file"
    ;;
  B009)
    echo Kindle DXG
    echo "$1" > "/sys/devices/platform/arc_udc/gadget/gadget-lun0/file"
    ;;
  B006)
    echo Kindle 3
    echo "$1" > "/sys/devices/platform/fsl-usb2-udc/gadget/gadget-lun0/file"
    ;;
  B008)
    echo Kindle 3
    echo "$1" > "/sys/devices/platform/fsl-usb2-udc/gadget/gadget-lun0/file"
    ;;
  B00A)
    echo Kindle 3
    echo "$1" > "/sys/devices/platform/fsl-usb2-udc/gadget/gadget-lun0/file"
    ;;
  *)
    echo No id
    ;;
  esac
}

app_exit_clean()
{
	  killall -9 ebook
	  killall -9 KindleApp
	  killall -9 UsbSignal.bin
	  killall -9 BatterySignal.bin
	  killall -9 Charging.bin
	  killall -9 notCharging.bin
	  killall -9 PowerState.bin
	  killall -9 suspending.bin
	  killall -9 lipc-wait-event
	  lipc-set-prop com.lab126.powerd preventScreenSaver 0
    cd /
    sync
}

#Ҫ˳ű   1
#Ҫ˳ű 	  2
ebook_exit_operation()
{
		ebookexitparam=$1
		if [ "$ebookexitparam" -eq 4 ];
    then
        get_usb_state
        if [ $? == 1 ]
        then
        		umount /mnt/base-us/
        		switch_otg "/dev/mmcblk0p4"
        		usb_state=$(lipc-wait-event -s 0 com.lab126.hal usbUnconfigured,usbPlugOut)
        		switch_otg " "
        fi
    return 1
    elif [ "$ebookexitparam" -eq 5 ];                           
    then                                            
        echo "go back kindle"
        stitch_to_kindle           
    exit 2
    elif [ "$ebookexitparam" -eq 6 ];                           
    then                                            
        stitch_to_lite
    exit 2
    elif [ "$ebookexitparam" -eq 8 ] ;                                                    
    then 
        sync
        shutdown -r -F now
    exit 2
    elif [ "$ebookexitparam" -eq 99 ];
		then
				sync
				killall -9 usbsingle.sh
				cp /mnt/us/DK_System/bin/UnInstall.sh /dev
				cd /
				/dev/UnInstall.sh ebook
		return 2
		elif [ "$ebookexitparam" -eq 88 ];
		then
				mntroot rw
				echo "update now........"
				
				if [ -f /mnt/us/DK_DownLoad/install.sh ]
				then
						chmod +x /mnt/us/DK_DownLoad/install.sh
						/mnt/us/DK_DownLoad/install.sh
						rm /mnt/us/DK_DownLoad/ -rf
				fi
				
				sync
				echo "updateall....."
				mntroot ro
		return 1
		elif [ "$ebookexitparam" -eq 127 ] ;
    then
          echo "reboot "
          mv /etc/rc5.d/S96rundk /etc/rc5.d/s96rundk
          sync
          shutdown -r -F now
    return 2
    else
          lipc-set-prop com.lab126.audio Kill 1
          rm /dev/viewinfodat1.txt
          rm /dev/viewinfodat.txt
          echo "run ebook" 
          /mnt/us/DK_System/bin/DKPrivateProfile -w SystemCrash 1 /mnt/us/DK_System/config.ini
          sync
    return 1
    fi
    return 2
}
run_ebook()
{
		killall -9 ebook
		iret=2
	  if [ -f /mnt/us/DK_System/bin/ebook ]
		then
        	LoadRunEorr=$(cat /mnt/us/DK_System/config.ini  | awk -F= '/LoadRunOK/{printf $2}')
        	if [ "$LoadRunEorr" -eq 0 ]
        	then
          		if [ $LoadRunEorrCount -le 2 ]
          		then
            			LoadRunEorrCount=$((LoadRunEorrCount+1))
          		else
            			/mnt/us/DK_System/bin/DKPrivateProfile -w DefaultSystem 0 /mnt/us/DK_System/config.ini
            			/mnt/us/DK_System/bin/DKPrivateProfile -w LoadRunOK 1 /mnt/us/DK_System/config.ini
            			echo rebootsystem
            			sync
            			shutdown -r -F now
            			exit
          		fi
        	else
          		LoadRunEorrCount=0
        	fi
        	/mnt/us/DK_System/bin/DKPrivateProfile -w LoadRunOK 0 /mnt/us/DK_System/config.ini
        	
        	chmod +x /mnt/us/DK_System/bin/ebook
        	chmod +x /mnt/us/DK_System/bin/lcrun
        	
        	/mnt/us/DK_System/bin/lcrun /mnt/us/DK_System/bin/ebook 
          iret=$?
          echo $iret
          app_exit_clean
  				ebook_exit_operation $iret
  				return $?
		fi
    return $APP_EBOOK_NOTFOND_RET
}
setup_lite()
{
		if [ ! -d $SYS_LITE_PATH ]
		then
				mntroot rw
				mkdir -p $SYS_LITE_PATH
				mntroot ro
		fi
		
		if [ -f $USER_LITE_PATH/KindleApp ]
		then
				mntroot rw
				rm /core.* -f
				mntroot rw
				rm $SYS_LITE_PATH/KindleApp 
				mntroot rw
				mv $USER_LITE_PATH/KindleApp $SYS_LITE_PATH/KindleApp
				
				mntroot rw
				rm $SYS_LITE_PATH/UsbSignal.bin
				mntroot rw
				mv $USER_LITE_PATH/UsbSignal.bin $SYS_LITE_PATH/UsbSignal.bin
				mntroot rw
				rm $SYS_LITE_PATH/BatterySignal.bin
				mntroot rw
				mv $USER_LITE_PATH/BatterySignal.bin $SYS_LITE_PATH/BatterySignal.bin
				mntroot rw
				rm $SYS_LITE_PATH/Charging.bin
				mntroot rw
				mv $USER_LITE_PATH/Charging.bin $SYS_LITE_PATH/Charging.bin
				mntroot rw
				rm $SYS_LITE_PATH/notCharging.bin
				mntroot rw
				mv $USER_LITE_PATH/notCharging.bin $SYS_LITE_PATH/notCharging.bin
				mntroot rw
				rm $SYS_LITE_PATH/PowerState.bin
				mntroot rw
				mv $USER_LITE_PATH/PowerState.bin $SYS_LITE_PATH/PowerState.bin
				mntroot rw
				rm $SYS_LITE_PATH/suspending.bin
				mntroot rw
				mv $USER_LITE_PATH/suspending.bin $SYS_LITE_PATH/suspending.bin
				mntroot rw
				rm $SYS_LITE_PATH/lib -rf
				mntroot rw
				mv $USER_LITE_PATH/lib $SYS_LITE_PATH/
				
				mntroot rw
				$USER_LITE_PATH/installlib.sh
				mntroot rw
				rm $USER_LITE_PATH/installlib.sh
				
				#TODO: û̫ڿĿ¼ϵͳռ
				mntroot rw
				mkdir -p $SYS_LITE_PATH/res
				cp $USER_LITE_PATH/res/* 			$SYS_LITE_PATH/res
				rm $USER_LITE_PATH/res/*
				mkdir -p $SYS_LITE_PATH/res/fontconfig
				cp -r $USER_LITE_PATH/res/fontconfig/* $SYS_LITE_PATH/res/fontconfig
				rm -rf $USER_LITE_PATH/res/fontconfig/* 
				mkdir -p $SYS_LITE_PATH/res/py
				cp -r $USER_LITE_PATH/res/py/* $SYS_LITE_PATH/res/py
				rm -rf $USER_LITE_PATH/res/py/*
				mkdir -p $SYS_LITE_PATH/res/sysfonts
				cp -r  $USER_LITE_PATH/res/sysfonts/* $SYS_LITE_PATH/res/sysfonts
				rm -rf $USER_LITE_PATH/res/sysfonts/*
				mkdir -p $SYS_LITE_PATH/res/CssAliases
				cp $USER_LITE_PATH/res/CssAliases/Aliases $SYS_LITE_PATH/res/CssAliases
				rm $USER_LITE_PATH/res/CssAliases/Aliases
				mkdir -p $USER_LITE_PATH/res/ScreenSaver
				mkdir -p $USER_LITE_PATH/res/language 
				mkdir -p $USER_LITE_PATH/res/dict
				mkdir -p $USER_LITE_PATH/SQMData
				mkdir -p $USER_LITE_PATH/res/userfonts
				
				mntroot rw
				chmod +x $SYS_LITE_PATH/KindleApp
				mntroot rw
				chmod +x $SYS_LITE_PATH/UsbSignal.bin
				mntroot rw
				chmod +x $SYS_LITE_PATH/BatterySignal.bin
				mntroot rw
				chmod +x $SYS_LITE_PATH/Charging.bin
				mntroot rw
				chmod +x $SYS_LITE_PATH/notCharging.bin
				mntroot rw
				chmod +x $SYS_LITE_PATH/PowerState.bin
				mntroot rw
				chmod +x $SYS_LITE_PATH/suspending.bin
				mntroot ro


		fi 
}

#Ҫ˳ű   1
#Ҫ˳ű 	  2
lite_exit_operation()
{
	liteexitparam=$1
  if [ "$liteexitparam" -eq 4 ];
  then                                            
      stitch_to_kindle
  return 2
  elif [ "$liteexitparam" -eq 5 ] ;
  then
      stitch_to_ebook
  return 2
  elif [ "$liteexitparam" -eq 6 ] ;                                                    
  then 
      sync
      shutdown -r -F now
  return 2
  elif [ "$liteexitparam" -eq 7 ];
	then
			cp /mnt/us/DK_System/bin/UnInstall.sh /dev
			cd /
			/dev/UnInstall.sh lite
			return 2
	elif [ "$liteexitparam" -eq 8 ];
	then
		sync
		echo "update now........"
		$DK_USER_PATH/bin/update.sh
		sync
		echo "updateall....."
	elif [ "$liteexitparam" -eq 10 ]
	then
		if [ -f /mnt/us/DK_System/install/liteinstall.sh ]
		then
			mntroot rw
			chmod +x /mnt/us/DK_System/install/liteinstall.sh
			/mnt/us/DK_System/install/liteinstall.sh
			rm /mnt/us/DK_System/install/liteinstall.sh
			sync
			mntroot ro
			run_lite
			return 0
		fi
  else
  				lipc-set-prop com.lab126.audio Kill 1
          sync
  fi
  
}
run_lite()
{
		killall -9 KindleApp
		setup_lite
		cd $SYS_LITE_PATH
		LD_LIBRARY_PATH=.:$SYS_LITE_PATH/lib/:../lib/:${LD_LIBRARY_PATH}
		FONTCONFIG_PATH=$SYS_LITE_PATH/res/fontconfig
		export LD_LIBRARY_PATH
		export FONTCONFIG_PATH
		
		if [ -f $SYS_LITE_PATH/KindleApp ]
		then
					./UsbSignal.bin &
					./BatterySignal.bin &
					./Charging.bin &
					./notCharging.bin &
					./PowerState.bin &
					./suspending.bin &
					./KindleApp
					iret=$?
          echo $iret
          app_exit_clean
  				lite_exit_operation $iret
  				return $?
		fi
		return $APP_LITE_NOTFOND_RET
}
run_app()
{
		runswitch=$1
		i=0
		iret=0
		LoadRunEorrCount=0
		# Make sure we're not in screensaver on system startup
    lipc-set-prop com.lab126.powerd wakeUp 1
		while [ $i -le 10 ];
		do 
				if [ $runswitch == "ebook" ];
				then
						run_ebook
						iret=$?
						umount /mnt/base-us
        		sleep 1
        		mount -t vfat -o defaults,noatime,nodiratime,utf8,noexec,shortname=winnt /dev/loop/0 /mnt/base-us/
        		sleep 1
				elif [ $runswitch == "lite" ]
				then
						run_lite
						iret=$?
				else
						echo "error"
						iret=2
				fi
        
				if [ $iret -eq 2 ]
				then
						return;
				elif [ $iret -eq $APP_EBOOK_NOTFOND_RET ]
				then
						stitch_to_kindle
    				#shutdown -r -F now
    				return ;
    		elif [ $iret -eq $APP_LITE_NOTFOND_RET ]
				then
						stitch_to_ebook
    				#shutdown -r -F now
    				return ;
				fi
				i=$((i+1))
		done
		
		stitch_to_kindle
    #shutdown -r -F now
    return ;
}
#Ӽlite汾
if [ -f /mnt/us/DK_System/install/liteinstall.sh ]
then
		mntroot rw
	  chmod +x /mnt/us/DK_System/install/liteinstall.sh
	  /mnt/us/DK_System/install/liteinstall.sh
	  rm /mnt/us/DK_System/install/liteinstall.sh
	  sync
	  mntroot ro
	  /etc/rc5.d/S96rundk
	  return 0
fi

DEFAULT_RUN=$1
if [ -z $1 ] 
then
	 	DEFAULT_RUN="ebook"
fi
run_app $DEFAULT_RUN