#!/usr/bin/python2

import os
import os.path
import mobiunpack_test_fand

mobiunpack_test_fand.DEBUG_NCX = 1

path = '/disk/ebooks/'
#path = '/dev/shm/tmp/errors/'

results = {}

for root, dirs, files in os.walk(path):
	if not os.access(root, os.R_OK):
		print "Can't read dir", dir
		continue
	for file in files:
		if not file[-5:].lower() == '.mobi':
			continue
		fpath = os.path.join(root, file)
		ok = False
		status = ''
		try:
			ok = mobiunpack_test_fand.unpackBook(fpath, 'tmp')
			if ok == '':
				ok = 'no'
			elif ok:
				status = 'NCX OK @ %d bytes' % len(repr(ok))
				ok = 'ok'
			else:
				ok = 'warn'
				print fpath
		except Exception, e:
			status = "ERROR:" + e.message
			ok = 'err'
			print fpath
		
		results[fpath] = (ok, status)
		

stat = {'no':0, 'ok':0, 'warn':0, 'err':0}
digest = open('digest.txt', 'w')
for fpath in results.keys():
	ok, status = results[fpath]
	if not ok in ('no', 'ok'):
		digest.write('%s\t%s\n' % (fpath, status))
	stat[ok] += 1
digest.close()
print stat

			
