#!/bin/sh
# ds = current status of duokan process
# ks = current status of kindle process
# status starts with S if the process is active, T if the process is stopped,
# and nothing if the process is not found
eips -c
ds=$(ps -e j | grep -v awk | awk '/KindleApp/ { print $7 }')
ks=$(ps -e j | grep -v awk | awk '/cvm/ { print $7 }')
eips 0 20 "From DS: $ds KS: $ks" 

case $ks in
T*) 
;;
S*) 
#dbus-send --system /default com.lab126.powerd.userShutdown int32:1

/etc/init.d/framework stop
#wait 3
#kstop=$(killall -STOP cvm)
#if [ $kstop -ne 0 ]
#then
#eips 0 22 "$kstop Error sending Kindle STOP"
#sleep 1
#fi
;;
*) 
;;
esac

case $ds in
T*)
dcont=$(killall -cont KindleApp)
if [ $dcont -ne 0 ]
then
	eips 0 23 "$dcont Error sending Duokan CONT"
	sleep 1
fi
;;
S*)
;;
*)
# if duokan lite process not found at all, start it
# environment variables required by duokan lite
SYS_LITE_PATH=/test/DKLite/
USER_LITE_PATH=/mnt/us/DK_System/Lite/
RUN_TAG="$SYS_LITE_PATH/duokantag"
APP_LITE_NOTFOND_RET="100"
APP_EBOOK_NOTFOND_RET="110"
lipc-set-prop com.lab126.audio Kill 1
mntroot rw
if [ -f /etc/rc5.d/s96rundk ]
then
		mv /etc/rc5.d/s96rundk /etc/rc5.d/S96rundk
fi
mv /etc/rc5.d/S95framework /etc/rc5.d/s95framework
touch $RUN_TAG
echo  "lite" > $RUN_TAG
mntroot ro
/etc/rc5.d/S96rundk
;;
esac
#sleep 4
#dbus-send --system /default com.lab126.powerd.resuming int32:1
#sleep 1
#dbus-send --system /default com.lab126.powerd.usbPlugOut int32:1