/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.kindlet.ui;

import com.amazon.ebook.framework.gui.foundation.KWindow;
import com.amazon.ebook.framework.gui.foundation.v;
import com.amazon.ebook.framework.gui.foundation.w;
import com.amazon.kindle.kindlet.ui.KComponent;
import com.amazon.kindle.kindlet.ui.KTextComponent;
import com.amazon.kindle.kindlet.ui.border.KBorder;
import com.amazon.kindle.kindlet.ui.g;
import com.amazon.kindle.kindlet.ui.k;
import com.amazon.kindle.kindlet.ui.t;
import com.amazon.kindle.kindlet.ui.u;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;

public class KTextField
extends KTextComponent {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY = "";
    final g m_peer;
    protected int m_columns;
    private KWindow m_textFieldKWindow = null;
    private boolean m_okToDrawTextField = false;
    private Dimension m_preferredSizeCache = null;
    private Dimension m_maxSizeCache = null;
    private static final Set m_actionKeyCodes = new HashSet(){
        {
            1 a2;
            a2.add(AWTKeyStroke.getAWTKeyStroke(61451, 0, false));
            a2.add(AWTKeyStroke.getAWTKeyStroke(10, 0, false));
        }
    };

    public KTextField() {
        this(DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY, 0);
    }

    public KTextField(String text) {
        this(text, 0);
    }

    public KTextField(String text, String hint) {
        this(text, 0, hint);
    }

    public KTextField(int columns) {
        this(DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY, columns);
    }

    public KTextField(String text, int columns) {
        this(text, columns, DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY);
    }

    public KTextField(String text, int columns, String hint) {
        this(text, columns, hint, false);
    }

    protected KTextField(String text, int columns, String hint, boolean isPassword) {
        this.m_peer = new g(this, isPassword);
        this.setColumns(columns);
        this.m_peer.a(new t(this));
        Font a2 = this.m_peer.v();
        a2 = new Font("sansserif", a2.getStyle(), a2.getSize());
        this.m_peer.a(a2);
        super.setFont(a2);
        this.a(hint, false);
        this.setFocusable(true);
        this.m_peer.b(false);
        this.m_peer.a(text);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(12L);
    }

    private synchronized KWindow a() {
        KTextField a2;
        if (a2.m_textFieldKWindow == null) {
            a2.m_textFieldKWindow = k.a(a2.getParent());
            if (a2.m_textFieldKWindow == null) {
                throw new IllegalStateException("No Kwindow parent found for textField");
            }
            a2.m_peer.a(a2.m_textFieldKWindow);
        }
        return a2.m_textFieldKWindow;
    }

    public int getColumns() {
        return this.m_columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int a2 = this.m_columns;
            if (columns < 0) {
                throw new UnsupportedOperationException("columns out of bounds.");
            }
            if (columns != a2) {
                this.m_columns = columns;
                this.invalidate();
            }
        }
    }

    public String getText() {
        return this.m_peer.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        Object object = this.getTreeLock();
        synchronized (object) {
            String a2 = text != null ? text : DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY;
            String a3 = this.m_peer.d();
            if (!a2.equals(a3)) {
                this.m_peer.a(a2);
                k.a((KComponent)this, (w)this.m_peer, a3, this.m_peer.d());
            }
        }
    }

    public boolean isEditable() {
        return true;
    }

    public void setEditable(boolean b2) {
    }

    public Color getBackground() {
        return this.m_peer.L();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Insets getMargin() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return new Insets(this.m_peer.q(), this.m_peer.p(), this.m_peer.P(), this.m_peer.Q());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMargin(Insets insets) {
        Insets a2;
        boolean a3 = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            a2 = this.getMargin();
            if (null == insets) {
                if (a2.left != 0 || a2.right != 0 || a2.top != 0 || a2.bottom != 0) {
                    this.m_peer.f(0);
                    this.m_peer.E(0);
                    this.m_peer.e(0);
                    this.m_peer.F(0);
                    a3 = true;
                    this.invalidate();
                }
            } else if (a2.left != insets.left || a2.right != insets.right || a2.top != insets.top || a2.bottom != insets.bottom) {
                this.m_peer.f(insets.top);
                this.m_peer.E(insets.bottom);
                this.m_peer.e(insets.left);
                this.m_peer.F(insets.right);
                a3 = true;
                this.invalidate();
            }
        }
        if (a3) {
            this.firePropertyChange("margin", a2, insets);
        }
    }

    public Color getForeground() {
        return this.m_peer.l();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setBackground(color);
            this.m_peer.A(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setForeground(color);
            this.m_peer.a(color);
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect != null) {
            this.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x2, int y2, int width, int height) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a2 = this.getMaximumSize();
            int a3 = Math.min(a2.height, height);
            int a4 = Math.min(a2.width, width);
            super.setBounds(x2, y2, a4, a3);
            this.m_peer.a(x2, y2, a4, a3);
        }
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean value) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setVisible(value);
            this.m_peer.d(value);
        }
    }

    public Font getFont() {
        return this.m_peer.v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font f2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (k.a((v)this.m_peer, (KTextComponent)this, f2)) {
                this.invalidate();
                super.setFont(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.invalidate();
            this.m_preferredSizeCache = null;
            this.m_maxSizeCache = null;
        }
    }

    public Dimension getMinimumSize() {
        return k.a((w)this.m_peer, (KTextComponent)this, super.getMinimumSize(1, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension a2 = this.m_preferredSizeCache;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets a3;
            u a4 = u.a(this);
            int a5 = a4.b() + 2;
            int a6 = a4.a(this.m_peer.d()) + 6;
            if (this.m_columns > 0) {
                a6 = Math.max(a6, this.m_columns * this.getColumnWidth());
            }
            if (null != (a3 = this.getInsets())) {
                int a7 = a3.left + a3.right;
                a6 = Math.max(0, a6 + a7);
                a5 += Math.max(0, a3.top + a3.bottom);
            }
            Dimension a8 = this.getAncestorMaxInteriorSize();
            if (a8.height > 0 && a8.width > 0) {
                a8.setSize(Math.min(a8.width, a6), Math.min(a8.height, a5));
            }
            this.m_preferredSizeCache = a8;
            return (Dimension)this.m_preferredSizeCache.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Dimension a2 = this.m_maxSizeCache;
        if (a2 != null && this.isValid()) {
            return (Dimension)a2.clone();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension a3 = super.getMaximumSize();
            int a4 = u.a(this).b() + 2;
            Insets a5 = this.getInsets();
            if (null != a5) {
                a4 += Math.max(0, a5.top + a5.bottom);
            }
            a3.height = Math.min(a3.height, a4);
            this.m_maxSizeCache = a3;
            return (Dimension)this.m_maxSizeCache.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaretPosition(int column) {
        Object object = this.getTreeLock();
        synchronized (object) {
            String a2 = this.getText();
            if (column < 0 || a2 == null || column > a2.length()) {
                throw new IllegalArgumentException("request column is out of bounds.");
            }
            this.m_peer.a(column);
            this.invalidate();
        }
    }

    public void setCursor(Cursor cur) {
        throw new UnsupportedOperationException("Deprecated API. Use setCursorColumn(int) instead");
    }

    public int getCaretPosition() {
        return this.m_peer.a();
    }

    private void a(String a2, boolean a3) {
        KTextField a4;
        String a5 = a2 == null ? DEFAULT_ALTERNATE_TEXT_WHEN_EMPTY : a2;
        a4.m_peer.a(a5, a3);
    }

    protected void processKeyEvent(KeyEvent e2) {
        super.processKeyEvent(e2);
        k.a(this, (w)this.m_peer, e2, m_actionKeyCodes);
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        k.a((KTextComponent)this, (w)this.m_peer, e2);
    }

    public void setHint(String hint) {
        this.m_peer.C(hint);
    }

    public boolean hasFocus() {
        return this.m_peer.F();
    }

    protected void drawBorder(Graphics g2) {
        KBorder a2 = this.getBorder();
        if (a2 != null) {
            a2.paintBorder(this, g2, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paint(Graphics g2) {
        this.paintAll(g2);
    }

    public void paintAll(Graphics g2) {
        this.drawBorder(g2);
        Graphics a2 = this.a().getGraphics().create();
        this.m_okToDrawTextField = true;
        this.m_peer.A(this.hasFocus(), false);
        this.m_peer.B(a2);
    }

    static /* synthetic */ KWindow A(KTextField a2) {
        return a2.a();
    }

    static /* synthetic */ boolean a(KTextField a2) {
        return a2.m_okToDrawTextField;
    }
}

